/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.Map;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PassphraseMapKeyRingProtector;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.Passphrase;

public interface SecretKeyRingProtector {
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long var1) throws PGPException;

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long var1) throws PGPException;

    public static SecretKeyRingProtector unlockAllKeysWith(Passphrase passphrase, PGPSecretKeyRing keys) {
        return PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)keys, passphrase);
    }

    public static SecretKeyRingProtector unlockSingleKeyWith(Passphrase passphrase, PGPSecretKey key) {
        return PasswordBasedSecretKeyRingProtector.forKey(key, passphrase);
    }

    public static SecretKeyRingProtector unprotectedKeys() {
        return new UnprotectedKeysProtector();
    }

    public static SecretKeyRingProtector fromPassphraseMap(Map<Long, Passphrase> passphraseMap) {
        return new PassphraseMapKeyRingProtector(passphraseMap, KeyRingProtectionSettings.secureDefaultSettings(), null);
    }
}

