/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.selection.key.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.pgpainless.key.selection.key.PublicKeySelectionStrategy;
import org.pgpainless.key.selection.key.SecretKeySelectionStrategy;

public class And {

    public static class SecKeySelectionStrategy
    extends SecretKeySelectionStrategy {
        private final Set<SecretKeySelectionStrategy> strategies = new HashSet<SecretKeySelectionStrategy>();

        public SecKeySelectionStrategy(SecretKeySelectionStrategy ... strategies) {
            this.strategies.addAll(Arrays.asList(strategies));
        }

        @Override
        public boolean accept(PGPSecretKey key) {
            boolean accept = true;
            for (SecretKeySelectionStrategy strategy : this.strategies) {
                accept &= strategy.accept(key);
            }
            return accept;
        }
    }

    public static class PubKeySelectionStrategy
    extends PublicKeySelectionStrategy {
        private final Set<PublicKeySelectionStrategy> strategies = new HashSet<PublicKeySelectionStrategy>();

        public PubKeySelectionStrategy(PublicKeySelectionStrategy ... strategies) {
            this.strategies.addAll(Arrays.asList(strategies));
        }

        @Override
        public boolean accept(PGPPublicKey key) {
            boolean accept = true;
            for (PublicKeySelectionStrategy strategy : this.strategies) {
                accept &= strategy.accept(key);
            }
            return accept;
        }
    }
}

