/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.selection.key.impl.NoRevocation;
import org.pgpainless.key.selection.key.impl.SignedByMasterKey;
import org.pgpainless.key.selection.key.util.And;

public class BCUtil {
    private static final Logger LOGGER = Logger.getLogger(BCUtil.class.getName());

    public static PGPPublicKeyRingCollection keyRingsToKeyRingCollection(PGPPublicKeyRing ... rings) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection(Arrays.asList(rings));
    }

    public static PGPSecretKeyRingCollection keyRingsToKeyRingCollection(PGPSecretKeyRing ... rings) throws IOException, PGPException {
        return new PGPSecretKeyRingCollection(Arrays.asList(rings));
    }

    public static PGPPublicKeyRing publicKeyRingFromSecretKeyRing(@Nonnull PGPSecretKeyRing secretKeys) throws PGPException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
        for (PGPSecretKey secretKey : secretKeys) {
            PGPPublicKey publicKey = secretKey.getPublicKey();
            if (publicKey == null) continue;
            publicKey.encode((OutputStream)buffer, false);
        }
        KeyFingerPrintCalculator fingerprintCalculator = ImplementationFactory.getInstance().getKeyFingerprintCalculator();
        return new PGPPublicKeyRing(buffer.toByteArray(), fingerprintCalculator);
    }

    public static PGPSecretKeyRing getKeyRingFromCollection(@Nonnull PGPSecretKeyRingCollection collection, @Nonnull Long id) throws PGPException {
        PGPSecretKeyRing uncleanedRing = collection.getSecretKeyRing(id.longValue());
        HashSet<Long> signedKeyIds = new HashSet<Long>();
        signedKeyIds.add(id);
        Iterator signedPubKeys = uncleanedRing.getKeysWithSignaturesBy(id.longValue());
        while (signedPubKeys.hasNext()) {
            signedKeyIds.add(((PGPPublicKey)signedPubKeys.next()).getKeyID());
        }
        PGPSecretKeyRing cleanedRing = uncleanedRing;
        Iterator secretKeys = uncleanedRing.getSecretKeys();
        while (secretKeys.hasNext()) {
            PGPSecretKey secretKey = (PGPSecretKey)secretKeys.next();
            if (signedKeyIds.contains(secretKey.getKeyID())) continue;
            cleanedRing = PGPSecretKeyRing.removeSecretKey((PGPSecretKeyRing)cleanedRing, (PGPSecretKey)secretKey);
        }
        return cleanedRing;
    }

    public static PGPPublicKeyRing getKeyRingFromCollection(@Nonnull PGPPublicKeyRingCollection collection, @Nonnull Long id) throws PGPException {
        PGPPublicKey key = collection.getPublicKey(id.longValue());
        return BCUtil.removeUnassociatedKeysFromKeyRing(collection.getPublicKeyRing(id.longValue()), key);
    }

    public static InputStream getPgpDecoderInputStream(@Nonnull byte[] bytes) throws IOException {
        return BCUtil.getPgpDecoderInputStream(new ByteArrayInputStream(bytes));
    }

    public static InputStream getPgpDecoderInputStream(@Nonnull InputStream inputStream) throws IOException {
        return PGPUtil.getDecoderStream((InputStream)inputStream);
    }

    public static byte[] getDecodedBytes(@Nonnull byte[] bytes) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)BCUtil.getPgpDecoderInputStream(bytes), (OutputStream)buffer);
        return buffer.toByteArray();
    }

    public static byte[] getDecodedBytes(@Nonnull InputStream inputStream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)buffer);
        return BCUtil.getDecodedBytes(buffer.toByteArray());
    }

    public static PGPPublicKeyRing removeUnassociatedKeysFromKeyRing(@Nonnull PGPPublicKeyRing ring, @Nonnull PGPPublicKey masterKey) {
        if (!masterKey.isMasterKey()) {
            throw new IllegalArgumentException("Given key is not a master key.");
        }
        And.PubKeySelectionStrategy selector = new And.PubKeySelectionStrategy(new SignedByMasterKey.PubkeySelectionStrategy(masterKey), new NoRevocation.PubKeySelectionStrategy());
        PGPPublicKeyRing cleaned = ring;
        Iterator publicKeys = ring.getPublicKeys();
        while (publicKeys.hasNext()) {
            PGPPublicKey publicKey = (PGPPublicKey)publicKeys.next();
            if (selector.accept(publicKey)) continue;
            cleaned = PGPPublicKeyRing.removePublicKey((PGPPublicKeyRing)cleaned, (PGPPublicKey)publicKey);
        }
        return cleaned;
    }

    public static PGPSecretKeyRing removeUnassociatedKeysFromKeyRing(@Nonnull PGPSecretKeyRing ring, @Nonnull PGPPublicKey masterKey) {
        if (!masterKey.isMasterKey()) {
            throw new IllegalArgumentException("Given key is not a master key.");
        }
        And.PubKeySelectionStrategy selector = new And.PubKeySelectionStrategy(new SignedByMasterKey.PubkeySelectionStrategy(masterKey), new NoRevocation.PubKeySelectionStrategy());
        PGPSecretKeyRing cleaned = ring;
        Iterator secretKeys = ring.getSecretKeys();
        while (secretKeys.hasNext()) {
            PGPSecretKey secretKey = (PGPSecretKey)secretKeys.next();
            if (selector.accept(secretKey.getPublicKey())) continue;
            cleaned = PGPSecretKeyRing.removeSecretKey((PGPSecretKeyRing)cleaned, (PGPSecretKey)secretKey);
        }
        return cleaned;
    }

    public static PGPPublicKey getMasterKeyFrom(@Nonnull PGPPublicKeyRing ring) {
        Iterator it = ring.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            if (!k.isMasterKey()) continue;
            return k;
        }
        return null;
    }

    public static PGPPublicKey getMasterKeyFrom(@Nonnull PGPKeyRing ring) {
        Iterator it = ring.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            if (!k.isMasterKey()) continue;
            return k;
        }
        return null;
    }

    public static Set<Long> signingKeyIds(@Nonnull PGPSecretKeyRing ring) {
        HashSet<Long> ids = new HashSet<Long>();
        Iterator it = ring.getPublicKeys();
        while (it.hasNext()) {
            PGPPublicKey k = (PGPPublicKey)it.next();
            boolean signingKey = false;
            Iterator sit = k.getSignatures();
            while (sit.hasNext()) {
                PGPSignature s;
                Object n = sit.next();
                if (!(n instanceof PGPSignature) || !(s = (PGPSignature)n).hasSubpackets()) continue;
                try {
                    s.verifyCertification(ring.getPublicKey(s.getKeyID()));
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Could not verify signature on " + Long.toHexString(k.getKeyID()) + " made by " + Long.toHexString(s.getKeyID()));
                    continue;
                }
                PGPSignatureSubpacketVector hashed = s.getHashedSubPackets();
                if (!KeyFlag.fromBitmask(hashed.getKeyFlags()).contains((Object)KeyFlag.SIGN_DATA)) continue;
                signingKey = true;
                break;
            }
            if (!signingKey) continue;
            ids.add(k.getKeyID());
        }
        return ids;
    }

    public static boolean keyRingContainsKeyWithId(@Nonnull PGPPublicKeyRing ring, long keyId) {
        return ring.getPublicKey(keyId) != null;
    }

    public static boolean keyRingContainsKeyWithId(@Nonnull PGPSecretKeyRing ring, long keyId) {
        return ring.getSecretKey(keyId) != null;
    }
}

