/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.elgamal.ElGamal;
import org.pgpainless.key.generation.type.elgamal.ElGamalLength;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.BCUtil;

public class EncryptDecryptTest {
    private static final Logger LOGGER = Logger.getLogger(EncryptDecryptTest.class.getName());
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String testMessage = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.";

    @Test
    public void freshKeysRsaToElGamalTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)ElGamal.withLength((ElGamalLength)ElGamalLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._4096)).withKeyFlags(new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.CERTIFY_OTHER}).withDefaultAlgorithms()).withPrimaryUserId("juliet@capulet.lit").withoutPassphrase().build();
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysRsaToRsaTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysEcToEcTest() throws IOException, PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysEcToRsaTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleEcKeyRing("romeo@montague.lit");
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleRsaKeyRing("juliet@capulet.lit", RsaLength._3072);
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void freshKeysRsaToEcTest() throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, IOException {
        PGPSecretKeyRing sender = PGPainless.generateKeyRing().simpleRsaKeyRing("romeo@montague.lit", RsaLength._3072);
        PGPSecretKeyRing recipient = PGPainless.generateKeyRing().simpleEcKeyRing("juliet@capulet.lit");
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    @Test
    public void existingRsaKeysTest() throws IOException, PGPException {
        PGPSecretKeyRing sender = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRing recipient = TestKeys.getRomeoSecretKeyRing();
        this.encryptDecryptForSecretKeyRings(sender, recipient);
    }

    private void encryptDecryptForSecretKeyRings(PGPSecretKeyRing senderSec, PGPSecretKeyRing recipientSec) throws PGPException, IOException {
        PGPPublicKeyRing recipientPub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)recipientSec);
        PGPPublicKeyRing senderPub = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)senderSec);
        UnprotectedKeysProtector keyDecryptor = new UnprotectedKeysProtector();
        byte[] secretMessage = testMessage.getBytes(UTF8);
        ByteArrayOutputStream envelope = new ByteArrayOutputStream();
        EncryptionStream encryptor = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)envelope).toRecipients(new PGPPublicKeyRing[]{recipientPub}).usingSecureAlgorithms().signWith((SecretKeyRingProtector)keyDecryptor, new PGPSecretKeyRing[]{senderSec}).signBinaryDocument().noArmor();
        Streams.pipeAll((InputStream)new ByteArrayInputStream(secretMessage), (OutputStream)encryptor);
        encryptor.close();
        byte[] encryptedSecretMessage = envelope.toByteArray();
        OpenPgpMetadata encryptionResult = encryptor.getResult();
        Assertions.assertFalse((boolean)encryptionResult.getSignatures().isEmpty());
        for (OpenPgpV4Fingerprint fingerprint : encryptionResult.getVerifiedSignatures().keySet()) {
            Assertions.assertTrue((boolean)BCUtil.keyRingContainsKeyWithId((PGPPublicKeyRing)senderPub, (long)fingerprint.getKeyId()));
        }
        Assertions.assertFalse((boolean)encryptionResult.getRecipientKeyIds().isEmpty());
        Iterator<Object> iterator = encryptionResult.getRecipientKeyIds().iterator();
        while (iterator.hasNext()) {
            long keyId = (Long)iterator.next();
            Assertions.assertTrue((boolean)BCUtil.keyRingContainsKeyWithId((PGPPublicKeyRing)recipientPub, (long)keyId));
        }
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_256, (Object)encryptionResult.getSymmetricKeyAlgorithm());
        ByteArrayInputStream envelopeIn = new ByteArrayInputStream(encryptedSecretMessage);
        DecryptionStream decryptor = PGPainless.decryptAndOrVerify().onInputStream((InputStream)envelopeIn).decryptWith((SecretKeyRingProtector)keyDecryptor, BCUtil.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{recipientSec})).verifyWith(BCUtil.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{senderPub})).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream decryptedSecretMessage = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptor, (OutputStream)decryptedSecretMessage);
        decryptor.close();
        Assertions.assertArrayEquals((byte[])secretMessage, (byte[])decryptedSecretMessage.toByteArray());
        OpenPgpMetadata result = decryptor.getResult();
        Assertions.assertTrue((boolean)result.containsVerifiedSignatureFrom(senderPub));
        Assertions.assertTrue((boolean)result.isIntegrityProtected());
        Assertions.assertTrue((boolean)result.isSigned());
        Assertions.assertTrue((boolean)result.isEncrypted());
        Assertions.assertTrue((boolean)result.isVerified());
    }

    @Test
    public void testDetachedSignatureCreationAndVerification() throws IOException, PGPException {
        PGPSecretKeyRing signingKeys = TestKeys.getJulietSecretKeyRing();
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream dummyOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dummyOut).doNotEncrypt().createDetachedSignature().signWith((SecretKeyRingProtector)keyRingProtector, new PGPSecretKeyRing[]{signingKeys}).signBinaryDocument().noArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        OpenPgpMetadata metadata = signer.getResult();
        Set signatureSet = metadata.getSignatures();
        ByteArrayOutputStream sigOut = new ByteArrayOutputStream();
        ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get((OutputStream)sigOut);
        ((PGPSignature)signatureSet.iterator().next()).encode((OutputStream)armorOut);
        armorOut.close();
        String armorSig = sigOut.toString();
        System.out.println(armorSig);
        inputStream = new ByteArrayInputStream(testMessage.getBytes());
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)inputStream).doNotDecrypt().verifyDetachedSignature((InputStream)new ByteArrayInputStream(armorSig.getBytes())).verifyWith(Collections.singleton(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)signingKeys))).ignoreMissingPublicKeys().build();
        dummyOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)dummyOut);
        verifier.close();
        metadata = verifier.getResult();
        Assertions.assertFalse((boolean)metadata.getVerifiedSignatures().isEmpty());
    }

    @Test
    public void testOnePassSignatureCreationAndVerification() throws IOException, PGPException {
        PGPSecretKeyRing signingKeys = TestKeys.getJulietSecretKeyRing();
        UnprotectedKeysProtector keyRingProtector = new UnprotectedKeysProtector();
        byte[] data = testMessage.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        ByteArrayOutputStream signOut = new ByteArrayOutputStream();
        EncryptionStream signer = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)signOut).doNotEncrypt().signWith((SecretKeyRingProtector)keyRingProtector, new PGPSecretKeyRing[]{signingKeys}).signBinaryDocument().asciiArmor();
        Streams.pipeAll((InputStream)inputStream, (OutputStream)signer);
        signer.close();
        System.out.println(signOut.toString());
        inputStream = new ByteArrayInputStream(signOut.toByteArray());
        DecryptionStream verifier = PGPainless.decryptAndOrVerify().onInputStream((InputStream)inputStream).doNotDecrypt().verifyWith(Collections.singleton(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)signingKeys))).ignoreMissingPublicKeys().build();
        signOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)verifier, (OutputStream)signOut);
        verifier.close();
        OpenPgpMetadata metadata = verifier.getResult();
        Assertions.assertFalse((boolean)metadata.getVerifiedSignatures().isEmpty());
    }
}

