/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;
import org.pgpainless.util.selection.key.impl.SignatureKeySelectionStrategy;

public class SigningTest {
    @Test
    public void testEncryptionAndSignatureVerification() throws IOException, PGPException {
        PGPPublicKeyRing julietKeys = TestKeys.getJulietPublicKeyRing();
        PGPPublicKeyRing romeoKeys = TestKeys.getRomeoPublicKeyRing();
        PGPSecretKeyRing cryptieKeys = TestKeys.getCryptieSecretKeyRing();
        PGPSecretKey cryptieSigningKey = (PGPSecretKey)new SignatureKeySelectionStrategy().selectKeysFromKeyRing(cryptieKeys).iterator().next();
        PGPPublicKeyRingCollection keys = new PGPPublicKeyRingCollection(Arrays.asList(julietKeys, romeoKeys));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign((EncryptionStream.Purpose)EncryptionStream.Purpose.STORAGE).onOutputStream((OutputStream)out).toRecipients(new PGPPublicKeyRingCollection[]{keys}).andToSelf(new PGPPublicKeyRing[]{KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)}).usingAlgorithms(SymmetricKeyAlgorithm.AES_192, HashAlgorithm.SHA384, CompressionAlgorithm.ZIP).signWith(SecretKeyRingProtector.unlockSingleKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKey)cryptieSigningKey), new PGPSecretKey[]{cryptieSigningKey}).signCanonicalText().asciiArmor();
        byte[] messageBytes = "This message is signed and encrypted to Romeo and Juliet.".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream message = new ByteArrayInputStream(messageBytes);
        Streams.pipeAll((InputStream)message, (OutputStream)encryptionStream);
        encryptionStream.close();
        byte[] encrypted = out.toByteArray();
        ByteArrayInputStream cryptIn = new ByteArrayInputStream(encrypted);
        PGPSecretKeyRing romeoSecret = TestKeys.getRomeoSecretKeyRing();
        PGPSecretKeyRing julietSecret = TestKeys.getJulietSecretKeyRing();
        PGPSecretKeyRingCollection secretKeys = new PGPSecretKeyRingCollection(Arrays.asList(romeoSecret, julietSecret));
        HashSet<OpenPgpV4Fingerprint> trustedFingerprints = new HashSet<OpenPgpV4Fingerprint>();
        trustedFingerprints.add(new OpenPgpV4Fingerprint(cryptieKeys));
        trustedFingerprints.add(new OpenPgpV4Fingerprint(julietKeys));
        PGPPublicKeyRingCollection verificationKeys = new PGPPublicKeyRingCollection(Arrays.asList(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys), romeoKeys));
        DecryptionStream decryptionStream = PGPainless.decryptAndOrVerify().onInputStream((InputStream)cryptIn).decryptWith(secretKeys).verifyWith(trustedFingerprints, verificationKeys).ignoreMissingPublicKeys().build();
        ByteArrayOutputStream plaintextOut = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decryptionStream, (OutputStream)plaintextOut);
        decryptionStream.close();
        OpenPgpMetadata metadata = decryptionStream.getResult();
        Assertions.assertEquals((Object)SymmetricKeyAlgorithm.AES_192, (Object)metadata.getSymmetricKeyAlgorithm());
        Assertions.assertEquals((int)HashAlgorithm.SHA384.getAlgorithmId(), (int)((PGPSignature)metadata.getSignatures().iterator().next()).getHashAlgorithm());
        Assertions.assertTrue((boolean)metadata.isEncrypted());
        Assertions.assertTrue((boolean)metadata.isSigned());
        Assertions.assertTrue((boolean)metadata.isVerified());
        Assertions.assertTrue((boolean)metadata.isIntegrityProtected());
        Assertions.assertTrue((boolean)metadata.containsVerifiedSignatureFrom(KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)cryptieKeys)));
        Assertions.assertFalse((boolean)metadata.containsVerifiedSignatureFrom(julietKeys));
    }
}

