/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.TestKeys;

public class ImportExportKeyTest {
    @Test
    public void testExportImportPublicKeyRing() throws IOException {
        PGPPublicKeyRing publicKeys = TestKeys.getJulietPublicKeyRing();
        BcKeyFingerprintCalculator calc = new BcKeyFingerprintCalculator();
        byte[] bytes = publicKeys.getEncoded();
        PGPPublicKeyRing parsed = new PGPPublicKeyRing(bytes, (KeyFingerPrintCalculator)calc);
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])parsed.getEncoded());
    }

    @Test
    public void testExportImportSecretKeyRing() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getRomeoSecretKeyRing();
        byte[] bytes = secretKeys.getEncoded();
        PGPSecretKeyRing parsed = new PGPSecretKeyRing(bytes, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])parsed.getEncoded());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)parsed.getPublicKey().getKeyID());
    }
}

