/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.info.KeyInfo;

public class BrainpoolKeyGeneration {
    @Test
    public void generateEcKeysTest() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        for (EllipticCurve curve : EllipticCurve.values()) {
            PGPSecretKeyRing secretKeys = this.generateKey(KeySpec.getBuilder((KeyType)KeyType.ECDSA((EllipticCurve)curve)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}).withDefaultAlgorithms(), KeySpec.getBuilder((KeyType)KeyType.ECDH((EllipticCurve)curve)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE}).withDefaultAlgorithms(), "Elliptic Curve <elliptic@curve.key>");
            Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)PublicKeyAlgorithm.fromId((int)secretKeys.getPublicKey().getAlgorithm()));
            PGPPublicKey publicKey = secretKeys.getPublicKey();
            Assertions.assertEquals((Object)curve.getName(), (Object)KeyInfo.getCurveName((PGPPublicKey)publicKey));
        }
    }

    public PGPSecretKeyRing generateKey(KeySpec primaryKey, KeySpec subKey, String userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().withSubKey(subKey).withPrimaryKey(primaryKey).withPrimaryUserId(userId).withoutPassphrase().build();
        return secretKeys;
    }
}

