/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.xdh.XDHCurve;

public class CertificationKeyMustBeAbleToCertifyTest {
    @Test
    public void testCertificationIncapableKeyTypesThrow() {
        KeyType[] typesIncapableOfCreatingVerifications;
        for (KeyType type : typesIncapableOfCreatingVerifications = new KeyType[]{KeyType.ECDH((EllipticCurve)EllipticCurve._P256), KeyType.ECDH((EllipticCurve)EllipticCurve._P384), KeyType.ECDH((EllipticCurve)EllipticCurve._P521), KeyType.XDH((XDHCurve)XDHCurve._X25519)}) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)type).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withPrimaryUserId("should@throw.ex").withoutPassphrase().build());
        }
    }
}

