/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHCurve;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.ArmorUtils;

public class GenerateEllipticCurveKeyTest {
    @Test
    public void test() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing keyRing = PGPainless.generateKeyRing().withSubKey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHCurve)XDHCurve._X25519)).withKeyFlags(new KeyFlag[]{KeyFlag.ENCRYPT_COMMS}).withDefaultAlgorithms()).withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA}).withDefaultAlgorithms()).withPrimaryUserId(UserId.onlyEmail((String)"alice@wonderland.lit").toString()).withoutPassphrase().build();
        System.out.println(ArmorUtils.toAsciiArmoredString((PGPSecretKeyRing)keyRing));
    }
}

