/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.Passphrase;

public class KeyRingInfoTest {
    @Test
    public void testWithEmilsKeys() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPPublicKeyRing publicKeys = TestKeys.getEmilPublicKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        KeyRingInfo pInfo = PGPainless.inspectKeyRing((PGPKeyRing)publicKeys);
        Assertions.assertEquals((long)6284463849526474508L, (long)sInfo.getKeyId());
        Assertions.assertEquals((long)6284463849526474508L, (long)pInfo.getKeyId());
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)sInfo.getFingerprint());
        Assertions.assertEquals((Object)TestKeys.EMIL_FINGERPRINT, (Object)pInfo.getFingerprint());
        Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)sInfo.getAlgorithm());
        Assertions.assertEquals((Object)PublicKeyAlgorithm.ECDSA, (Object)pInfo.getAlgorithm());
        Assertions.assertEquals((int)2, (int)sInfo.getPublicKeys().size());
        Assertions.assertEquals((int)2, (int)pInfo.getPublicKeys().size());
        Assertions.assertEquals(Collections.singletonList("<emil@email.user>"), (Object)sInfo.getUserIds());
        Assertions.assertEquals(Collections.singletonList("<emil@email.user>"), (Object)pInfo.getUserIds());
        Assertions.assertEquals(Collections.singletonList("emil@email.user"), (Object)sInfo.getEmailAddresses());
        Assertions.assertEquals(Collections.singletonList("emil@email.user"), (Object)pInfo.getEmailAddresses());
        Assertions.assertTrue((boolean)sInfo.isSecretKey());
        Assertions.assertFalse((boolean)pInfo.isSecretKey());
        Assertions.assertTrue((boolean)sInfo.isFullyDecrypted());
        Assertions.assertTrue((boolean)pInfo.isFullyDecrypted());
        Assertions.assertEquals((Object)TestKeys.EMIL_CREATION_DATE, (Object)sInfo.getCreationDate());
        Assertions.assertEquals((Object)TestKeys.EMIL_CREATION_DATE, (Object)pInfo.getCreationDate());
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Assertions.assertNull((Object)pInfo.getExpirationDate());
        Assertions.assertEquals((float)TestKeys.EMIL_CREATION_DATE.getTime(), (float)sInfo.getLastModified().getTime(), (float)50.0f);
        Assertions.assertEquals((float)TestKeys.EMIL_CREATION_DATE.getTime(), (float)pInfo.getLastModified().getTime(), (float)50.0f);
        Assertions.assertNull((Object)sInfo.getRevocationDate());
        Assertions.assertNull((Object)pInfo.getRevocationDate());
        Date revocationDate = new Date();
        PGPSecretKeyRing revoked = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).revoke((SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        KeyRingInfo rInfo = PGPainless.inspectKeyRing((PGPKeyRing)revoked);
        Assertions.assertNotNull((Object)rInfo.getRevocationDate());
        Assertions.assertEquals((float)revocationDate.getTime(), (float)rInfo.getRevocationDate().getTime(), (float)1000.0f);
        Assertions.assertEquals((float)revocationDate.getTime(), (float)rInfo.getLastModified().getTime(), (float)1000.0f);
    }

    @Test
    public void testIsFullyDecrypted() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyDecrypted());
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).changePassphraseFromOldPassphrase(null).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"sw0rdf1sh")).done();
        info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertFalse((boolean)info.isFullyDecrypted());
    }

    @Test
    public void testGetSecretKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimarySecretKeyFrom((PGPSecretKeyRing)secretKeys), (Object)info.getSecretKey());
        info = PGPainless.inspectKeyRing((PGPKeyRing)publicKeys);
        Assertions.assertNull((Object)info.getSecretKey());
    }

    @Test
    public void testGetPublicKey() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimaryPublicKeyFrom((PGPKeyRing)secretKeys), (Object)info.getPublicKey());
        Assertions.assertEquals((Object)KeyRingUtils.requirePrimarySecretKeyFrom((PGPSecretKeyRing)secretKeys), (Object)KeyRingUtils.requireSecretKeyFrom((PGPSecretKeyRing)secretKeys, (long)secretKeys.getPublicKey().getKeyID()));
    }
}

