/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;

public class ChangeExpirationTest {
    private final OpenPgpV4Fingerprint subKeyFingerprint = new OpenPgpV4Fingerprint("F73FDE6439ABE210B1AF4EDD273EF7A0C749807B");

    @Test
    public void setExpirationDateAndThenUnsetIt_OnPrimaryKey() throws PGPException, IOException, InterruptedException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Assertions.assertNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
        Date date = new Date(1606493432000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getExpirationDate());
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getExpirationDate().getTime());
        Assertions.assertNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Assertions.assertNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
    }

    @Test
    public void setExpirationDateAndThenUnsetIt_OnSubkey() throws PGPException, IOException, InterruptedException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Date date = new Date(1606493432000L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(this.subKeyFingerprint, date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getExpirationDate(this.subKeyFingerprint).getTime());
        Assertions.assertNull((Object)sInfo.getExpirationDate());
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(this.subKeyFingerprint, null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getExpirationDate(this.subKeyFingerprint));
        Assertions.assertNull((Object)sInfo.getExpirationDate());
    }
}

