/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;

public class ChangeSecretKeyRingPassphraseTest {
    private final PGPSecretKeyRing keyRing = PGPainless.generateKeyRing().simpleEcKeyRing("password@encryp.ted", "weakPassphrase");

    @Test
    public void changePassphraseOfWholeKeyRingTest() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys;
        PGPSecretKeyRing changedPassphraseKeyRing = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changePassphraseFromOldPassphrase(Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"1337p455phr453")).done();
        Assertions.assertEquals((int)KeyRingProtectionSettings.secureDefaultSettings().getEncryptionAlgorithm().getAlgorithmId(), (int)changedPassphraseKeyRing.getSecretKey().getKeyEncryptionAlgorithm());
        Assertions.assertThrows(PGPException.class, () -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.emptyPassphrase()), (String)"Unlocking secret key ring with empty passphrase MUST fail.");
        Assertions.assertThrows(PGPException.class, () -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking secret key ring with old passphrase MUST fail.");
        Assertions.assertDoesNotThrow(() -> this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.fromPassword((String)"1337p455phr453")), (String)"Unlocking the secret key ring with the new passphrase MUST succeed.");
    }

    @Test
    public void changePassphraseOfWholeKeyRingToEmptyPassphrase() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys;
        PGPSecretKeyRing changedPassphraseKeyRing = secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changePassphraseFromOldPassphrase(Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNoPassphrase().done();
        Assertions.assertEquals((int)SymmetricKeyAlgorithm.NULL.getAlgorithmId(), (int)changedPassphraseKeyRing.getSecretKey().getKeyEncryptionAlgorithm());
        this.signDummyMessageWithKeysAndPassphrase(changedPassphraseKeyRing, Passphrase.emptyPassphrase());
    }

    @Test
    public void changePassphraseOfSingleSubkeyToNewPassphrase() throws PGPException {
        Iterator keys = this.keyRing.getSecretKeys();
        PGPSecretKey primaryKey = (PGPSecretKey)keys.next();
        PGPSecretKey subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.fromPassword((String)"weakPassphrase"));
        this.extractPrivateKey(subKey, Passphrase.fromPassword((String)"weakPassphrase"));
        PGPSecretKeyRing secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changeSubKeyPassphraseFromOldPassphrase(Long.valueOf(subKey.getPublicKey().getKeyID()), Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNewPassphrase(Passphrase.fromPassword((String)"subKeyPassphrase")).done();
        keys = secretKeys.getSecretKeys();
        primaryKey = (PGPSecretKey)keys.next();
        subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.fromPassword((String)"weakPassphrase"));
        this.extractPrivateKey(subKey, Passphrase.fromPassword((String)"subKeyPassphrase"));
        PGPSecretKey finalPrimaryKey = primaryKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalPrimaryKey, Passphrase.fromPassword((String)"subKeyPassphrase")), (String)"Unlocking the primary key with the subkey passphrase must fail.");
        PGPSecretKey finalSubKey = subKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalSubKey, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking the subkey with the primary key passphrase must fail.");
    }

    @Test
    public void changePassphraseOfSingleSubkeyToEmptyPassphrase() throws PGPException {
        Iterator keys = this.keyRing.getSecretKeys();
        PGPSecretKey primaryKey = (PGPSecretKey)keys.next();
        PGPSecretKey subKey = (PGPSecretKey)keys.next();
        PGPSecretKeyRing secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)this.keyRing).changeSubKeyPassphraseFromOldPassphrase(Long.valueOf(primaryKey.getKeyID()), Passphrase.fromPassword((String)"weakPassphrase")).withSecureDefaultSettings().toNoPassphrase().done();
        keys = secretKeys.getSecretKeys();
        primaryKey = (PGPSecretKey)keys.next();
        subKey = (PGPSecretKey)keys.next();
        this.extractPrivateKey(primaryKey, Passphrase.emptyPassphrase());
        this.extractPrivateKey(subKey, Passphrase.fromPassword((String)"weakPassphrase"));
        PGPSecretKey finalPrimaryKey = primaryKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalPrimaryKey, Passphrase.fromPassword((String)"weakPassphrase")), (String)"Unlocking the unprotected primary key with the old passphrase must fail.");
        PGPSecretKey finalSubKey = subKey;
        Assertions.assertThrows(PGPException.class, () -> this.extractPrivateKey(finalSubKey, Passphrase.emptyPassphrase()), (String)"Unlocking the still protected subkey with an empty passphrase must fail.");
    }

    private void extractPrivateKey(PGPSecretKey secretKey, Passphrase passphrase) throws PGPException {
        BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
        if (passphrase.isEmpty() && secretKey.getKeyEncryptionAlgorithm() != SymmetricKeyAlgorithm.NULL.getAlgorithmId()) {
            throw new PGPException("Cannot unlock encrypted private key with empty passphrase.");
        }
        if (!passphrase.isEmpty() && secretKey.getKeyEncryptionAlgorithm() == SymmetricKeyAlgorithm.NULL.getAlgorithmId()) {
            throw new PGPException("Cannot unlock unprotected private key with non-empty passphrase.");
        }
        PBESecretKeyDecryptor decryptor = passphrase.isEmpty() ? null : new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)digestCalculatorProvider).build(passphrase.getChars());
        secretKey.extractPrivateKey(decryptor);
    }

    private void signDummyMessageWithKeysAndPassphrase(PGPSecretKeyRing keyRing, Passphrase passphrase) throws IOException, PGPException {
        String dummyMessage = "dummy";
        ByteArrayOutputStream dummy = new ByteArrayOutputStream();
        EncryptionStream stream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)dummy).doNotEncrypt().signWith((SecretKeyRingProtector)PasswordBasedSecretKeyRingProtector.forKey((PGPKeyRing)keyRing, (Passphrase)passphrase), new PGPSecretKeyRing[]{keyRing}).signBinaryDocument().noArmor();
        Streams.pipeAll((InputStream)new ByteArrayInputStream(dummyMessage.getBytes()), (OutputStream)stream);
        stream.close();
    }
}

