/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.ArmoredOutputStreamFactory;

public class RevokeKeyWithGenericCertificationSignatureTest {
    private static final String SAMPLE_PRIVATE_KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\r\nVersion: MyApplication 1.0.0\r\nComment: Some comment\r\n\r\nxVgEX6UIExYJKwYBBAHaRw8BAQdAMfHf64wPQ2LC9In5AKYU/KT1qWvI7e7a\r\nXr+LWeQGUKIAAQCcB3zZlHfepQT26LIwbTDn4lvQ9LuD1fk2hK6i9FXFxxO7\r\nzRI8dXNlckBleGFtcGxlLmNvbT7CjwQQFgoAIAUCX6UIEwYLCQcIAwIEFQgK\r\nAgQWAgEAAhkBAhsDAh4BACEJEEoCtcZ3snFuFiEENY1GQZqrKQqgUAXASgK1\r\nxneycW6P6AEA5iXFK+fWpj0vn3xpKEuFRqvytPKFzhwd4wEvL+IGSPEBALE/\r\npZdMzsDoKPENiLFpboDVNVJScwFXIleKmtNaRycFx10EX6UIExIKKwYBBAGX\r\nVQEFAQEHQBDdeawWVNqYkP8c/ihLEUlVpn8cQw7rmRc/sIhdAXhfAwEIBwAA\r\n/0Jy7IelcHDjxE3OzagEzSxNrCVw8uPHNRl8s6iP+CQYEfHCeAQYFggACQUC\r\nX6UIEwIbDAAhCRBKArXGd7JxbhYhBDWNRkGaqykKoFAFwEoCtcZ3snFuWp8B\r\nAIzRBYJSfZzlvlyyPhrbXJoYSICGNy/5x7noXjp/ByeOAQDnTbQi4XwXJrU4\r\nA8Nl9eyz16ZWUzEPwfWgahIG1eQDDA==\r\n=bk4o\r\n-----END PGP PRIVATE KEY BLOCK-----\r\n";

    @Test
    public void test() throws IOException, PGPException {
        this.revokeKey(SAMPLE_PRIVATE_KEY);
    }

    private KeyPair revokeKey(String priv) throws IOException, PGPException {
        byte[] armoredBytes = priv.getBytes(StandardCharsets.UTF_8);
        PGPSecretKeyRing r = PGPainless.readKeyRing().secretKeyRing(armoredBytes);
        PGPSecretKey secretKey = r.getSecretKey();
        PGPSecretKeyRing secretKeyRing = PGPainless.modifyKeyRing((PGPSecretKeyRing)new PGPSecretKeyRing(Arrays.asList(secretKey))).revoke((SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        PGPPublicKey pkr = (PGPPublicKey)secretKeyRing.getPublicKeys().next();
        ByteArrayOutputStream pubOutBytes = new ByteArrayOutputStream();
        try (ArmoredOutputStream pubOut = ArmoredOutputStreamFactory.get((OutputStream)pubOutBytes);){
            pkr.encode((OutputStream)pubOut);
        }
        pubOutBytes.close();
        PGPSecretKey skr = (PGPSecretKey)secretKeyRing.getSecretKeys().next();
        ByteArrayOutputStream secOutBytes = new ByteArrayOutputStream();
        try (ArmoredOutputStream privOut = ArmoredOutputStreamFactory.get((OutputStream)secOutBytes);){
            skr.encode((OutputStream)privOut);
        }
        secOutBytes.close();
        return new KeyPair(pubOutBytes.toByteArray(), secOutBytes.toByteArray());
    }

    public static class KeyPair {
        public final String pub;
        public final String priv;

        public KeyPair(byte[] pub, byte[] priv) {
            this.pub = new String(pub, StandardCharsets.UTF_8);
            this.priv = new String(pub, StandardCharsets.UTF_8);
        }
    }
}

