/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.MultiMap;

public class MultiMapTest {
    @Test
    public void test() {
        MultiMap multiMap = new MultiMap();
        Assertions.assertTrue((boolean)multiMap.isEmpty());
        Assertions.assertNull((Object)multiMap.get((Object)"alice"));
        Assertions.assertFalse((boolean)multiMap.containsKey((Object)"alice"));
        Assertions.assertFalse((boolean)multiMap.containsValue((Object)"wonderland"));
        Assertions.assertEquals((int)0, (int)multiMap.size());
        multiMap.put((Object)"alice", (Object)"wonderland");
        Assertions.assertFalse((boolean)multiMap.isEmpty());
        Assertions.assertEquals((int)1, (int)multiMap.size());
        Assertions.assertTrue((boolean)multiMap.containsKey((Object)"alice"));
        Assertions.assertTrue((boolean)multiMap.containsValue((Object)"wonderland"));
        Assertions.assertNotNull((Object)multiMap.get((Object)"alice"));
        Assertions.assertTrue((boolean)multiMap.get((Object)"alice").contains("wonderland"));
        multiMap.put((Object)"mad", new HashSet<String>(Arrays.asList("hatter", "max")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("hatter", "max")), (Object)multiMap.get((Object)"mad"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("mad", "alice")), (Object)multiMap.keySet());
        Assertions.assertEquals(new HashSet<Set>(Arrays.asList(Collections.singleton("wonderland"), new HashSet<String>(Arrays.asList("hatter", "max")))), new HashSet(multiMap.values()));
        Set entries = multiMap.entrySet();
        Assertions.assertEquals((int)2, (int)entries.size());
        block8: for (Map.Entry e : entries) {
            switch ((String)e.getKey()) {
                case "alice": {
                    Assertions.assertEquals((int)1, (int)((Set)e.getValue()).size());
                    Assertions.assertTrue((boolean)((Set)e.getValue()).contains("wonderland"));
                    continue block8;
                }
                case "mad": {
                    Assertions.assertEquals((int)2, (int)((Set)e.getValue()).size());
                    Assertions.assertTrue((boolean)((Set)e.getValue()).contains("hatter"));
                    Assertions.assertTrue((boolean)((Set)e.getValue()).contains("max"));
                    continue block8;
                }
            }
            Assertions.fail((String)"Illegal key.");
        }
        MultiMap empty = new MultiMap();
        Assertions.assertNotEquals((Object)multiMap, (Object)empty);
        Assertions.assertEquals((Object)multiMap, (Object)multiMap);
        Assertions.assertNotEquals(null, (Object)multiMap);
        MultiMap map2 = new MultiMap();
        map2.put((Object)"alice", (Object)"schwarzer");
        map2.put((Object)"dr", (Object)"strange");
        multiMap.putAll(map2);
        Assertions.assertTrue((boolean)multiMap.containsKey((Object)"dr"));
        Assertions.assertEquals((int)1, (int)multiMap.get((Object)"dr").size());
        Assertions.assertTrue((boolean)multiMap.get((Object)"dr").contains("strange"));
        Assertions.assertTrue((boolean)multiMap.containsKey((Object)"mad"));
        Assertions.assertEquals((int)2, (int)multiMap.get((Object)"alice").size());
        Assertions.assertTrue((boolean)multiMap.get((Object)"alice").contains("wonderland"));
        Assertions.assertTrue((boolean)multiMap.get((Object)"alice").contains("schwarzer"));
        multiMap.removeAll((Object)"mad");
        Assertions.assertFalse((boolean)multiMap.containsKey((Object)"mad"));
        Assertions.assertNull((Object)multiMap.get((Object)"mad"));
        multiMap.remove((Object)"alice", (Object)"wonderland");
        Assertions.assertFalse((boolean)multiMap.containsValue((Object)"wonderland"));
        Assertions.assertTrue((boolean)multiMap.containsKey((Object)"alice"));
        Assertions.assertEquals((int)1, (int)multiMap.get((Object)"alice").size());
        Assertions.assertTrue((boolean)multiMap.get((Object)"alice").contains("schwarzer"));
        MultiMap copy = new MultiMap(multiMap);
        Assertions.assertEquals((Object)multiMap, (Object)copy);
        copy.removeAll((Object)"inexistent");
        Assertions.assertEquals((Object)multiMap, (Object)copy);
        copy.remove((Object)"inexistent", (Object)"schwarzer");
        Assertions.assertEquals((Object)multiMap, (Object)copy);
        Assertions.assertEquals((int)multiMap.hashCode(), (int)copy.hashCode());
        copy.clear();
        Assertions.assertTrue((boolean)copy.isEmpty());
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put("key", Collections.singleton("value"));
        MultiMap fromMap = new MultiMap(map);
        Assertions.assertFalse((boolean)fromMap.isEmpty());
        Assertions.assertEquals((Object)fromMap.get((Object)"key"), Collections.singleton("value"));
        Assertions.assertNotEquals((Object)fromMap, map);
    }
}

