/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.weird_keys;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;

public class TestEncryptCommsStorageFlagsDifferentiated {
    @Test
    public void testThatEncryptionDifferentiatesBetweenPurposeKeyFlags() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = PGPainless.generateKeyRing().withPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072)).withKeyFlags(new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_STORAGE}).withDefaultAlgorithms()).withPrimaryUserId("cannot@encrypt.comms").withoutPassphrase().build();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionBuilderInterface.ToRecipients builder = PGPainless.encryptAndOrSign((EncryptionStream.Purpose)EncryptionStream.Purpose.COMMUNICATIONS).onOutputStream((OutputStream)out);
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.toRecipients(new PGPPublicKeyRing[]{publicKeys}));
    }
}

