/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.OnePassSignatureCheck;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.SignatureValidityComparator;
import org.pgpainless.signature.SignatureVerifier;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValidator.class);

    private CertificateValidator() {
    }

    public static boolean validateCertificate(PGPSignature signature, PGPPublicKeyRing signingKeyRing, Policy policy) throws SignatureValidationException {
        PGPSignature userIdSig;
        ConcurrentHashMap<PGPSignature, Exception> rejections = new ConcurrentHashMap<PGPSignature, Exception>();
        long keyId = SignatureUtils.determineIssuerKeyId(signature);
        PGPPublicKey signingSubkey = signingKeyRing.getPublicKey(keyId);
        if (signingSubkey == null) {
            throw new SignatureValidationException("Provided key ring does not contain a subkey with id " + Long.toHexString(keyId));
        }
        PGPPublicKey primaryKey = signingKeyRing.getPublicKey();
        ArrayList<PGPSignature> directKeySignatures = new ArrayList<PGPSignature>();
        Iterator primaryKeyRevocationIterator = primaryKey.getSignaturesOfType(SignatureType.KEY_REVOCATION.getCode());
        while (primaryKeyRevocationIterator.hasNext()) {
            PGPSignature revocation = (PGPSignature)primaryKeyRevocationIterator.next();
            try {
                if (!SignatureVerifier.verifyKeyRevocationSignature(revocation, primaryKey, policy, signature.getCreationTime())) continue;
                directKeySignatures.add(revocation);
            }
            catch (SignatureValidationException e) {
                rejections.put(revocation, (Exception)((Object)e));
                LOGGER.debug("Rejecting key revocation signature: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Iterator keySignatures = primaryKey.getSignaturesOfType(SignatureType.DIRECT_KEY.getCode());
        while (keySignatures.hasNext()) {
            PGPSignature keySignature = (PGPSignature)keySignatures.next();
            try {
                if (!SignatureVerifier.verifyDirectKeySignature(keySignature, primaryKey, policy, signature.getCreationTime())) continue;
                directKeySignatures.add(keySignature);
            }
            catch (SignatureValidationException e) {
                rejections.put(keySignature, (Exception)((Object)e));
                LOGGER.debug("Rejecting key signature: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        Collections.sort(directKeySignatures, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
        if (!directKeySignatures.isEmpty() && ((PGPSignature)directKeySignatures.get(0)).getSignatureType() == SignatureType.KEY_REVOCATION.getCode()) {
            throw new SignatureValidationException("Primary key has been revoked.");
        }
        Iterator userIds = primaryKey.getUserIDs();
        ConcurrentHashMap userIdSignatures = new ConcurrentHashMap();
        while (userIds.hasNext()) {
            ArrayList<PGPSignature> signaturesOnUserId = new ArrayList<PGPSignature>();
            String userId = (String)userIds.next();
            Iterator userIdSigs = primaryKey.getSignaturesForID(userId);
            while (userIdSigs.hasNext()) {
                PGPSignature userIdSig2 = (PGPSignature)userIdSigs.next();
                try {
                    if (!SignatureVerifier.verifySignatureOverUserId(userId, userIdSig2, primaryKey, policy, signature.getCreationTime())) continue;
                    signaturesOnUserId.add(userIdSig2);
                }
                catch (SignatureValidationException e) {
                    rejections.put(userIdSig2, (Exception)((Object)e));
                    LOGGER.debug("Rejecting user-id signature: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            Collections.sort(signaturesOnUserId, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            userIdSignatures.put(userId, signaturesOnUserId);
        }
        boolean anyUserIdValid = false;
        for (String userId : userIdSignatures.keySet()) {
            if (((List)userIdSignatures.get(userId)).isEmpty()) continue;
            PGPSignature current = (PGPSignature)((List)userIdSignatures.get(userId)).get(0);
            if (current.getSignatureType() == SignatureType.CERTIFICATION_REVOCATION.getCode()) {
                LOGGER.debug("User-ID '{}' is revoked.", (Object)userId);
                continue;
            }
            anyUserIdValid = true;
        }
        if (!anyUserIdValid) {
            throw new SignatureValidationException("No valid user-id found.", rejections);
        }
        SignerUserID signerUserID = SignatureSubpacketsUtil.getSignerUserID(signature);
        if (signerUserID != null && (userIdSig = (PGPSignature)((List)userIdSignatures.get(signerUserID.getID())).get(0)).getSignatureType() == SignatureType.CERTIFICATION_REVOCATION.getCode()) {
            throw new SignatureValidationException("Signature was made with user-id '" + signerUserID.getID() + "' which is revoked.");
        }
        if (signingSubkey == primaryKey) {
            if (!directKeySignatures.isEmpty() && KeyFlag.hasKeyFlag(SignatureSubpacketsUtil.getKeyFlags((PGPSignature)directKeySignatures.get(0)).getFlags(), KeyFlag.SIGN_DATA)) {
                return true;
            }
        } else {
            ArrayList<PGPSignature> subkeySigs = new ArrayList<PGPSignature>();
            Iterator bindingRevocations = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_REVOCATION.getCode());
            while (bindingRevocations.hasNext()) {
                PGPSignature revocation = (PGPSignature)bindingRevocations.next();
                try {
                    if (!SignatureVerifier.verifySubkeyBindingRevocation(revocation, primaryKey, signingSubkey, policy, signature.getCreationTime())) continue;
                    subkeySigs.add(revocation);
                }
                catch (SignatureValidationException e) {
                    rejections.put(revocation, (Exception)((Object)e));
                    LOGGER.debug("Rejecting subkey revocation signature: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            Iterator bindingSigs = signingSubkey.getSignaturesOfType(SignatureType.SUBKEY_BINDING.getCode());
            while (bindingSigs.hasNext()) {
                PGPSignature bindingSig = (PGPSignature)bindingSigs.next();
                try {
                    if (!SignatureVerifier.verifySubkeyBindingSignature(bindingSig, primaryKey, signingSubkey, policy, signature.getCreationTime())) continue;
                    subkeySigs.add(bindingSig);
                }
                catch (SignatureValidationException e) {
                    rejections.put(bindingSig, (Exception)((Object)e));
                    LOGGER.debug("Rejecting subkey binding signature: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            Collections.sort(subkeySigs, new SignatureValidityComparator(SignatureCreationDateComparator.Order.NEW_TO_OLD));
            if (subkeySigs.isEmpty()) {
                throw new SignatureValidationException("Subkey is not bound.", rejections);
            }
            PGPSignature currentSig = (PGPSignature)subkeySigs.get(0);
            if (currentSig.getSignatureType() == SignatureType.SUBKEY_REVOCATION.getCode()) {
                throw new SignatureValidationException("Subkey is revoked.");
            }
            KeyFlags keyFlags = SignatureSubpacketsUtil.getKeyFlags(currentSig);
            if (keyFlags == null) {
                if (directKeySignatures.isEmpty()) {
                    throw new SignatureValidationException("Signature was made by key which is not capable of signing (no keyflags on binding sig, no direct-key sig).");
                }
                PGPSignature directKeySig = (PGPSignature)directKeySignatures.get(0);
                KeyFlags directKeyFlags = SignatureSubpacketsUtil.getKeyFlags(directKeySig);
                if (!KeyFlag.hasKeyFlag(directKeyFlags.getFlags(), KeyFlag.SIGN_DATA)) {
                    throw new SignatureValidationException("Signature was made by key which is not capable of signing (no keyflags on binding sig, no SIGN flag on direct-key sig).");
                }
            } else if (!KeyFlag.hasKeyFlag(keyFlags.getFlags(), KeyFlag.SIGN_DATA)) {
                throw new SignatureValidationException("Signature was made by key which is not capable of signing (no SIGN flag on binding sig).");
            }
        }
        return true;
    }

    public static boolean validateCertificateAndVerifyUninitializedSignature(PGPSignature signature, InputStream signedData, PGPPublicKeyRing signingKeyRing, Policy policy, Date validationDate) throws SignatureValidationException {
        CertificateValidator.validateCertificate(signature, signingKeyRing, policy);
        long keyId = SignatureUtils.determineIssuerKeyId(signature);
        return SignatureVerifier.verifyUninitializedSignature(signature, signedData, signingKeyRing.getPublicKey(keyId), policy, validationDate);
    }

    public static boolean validateCertificateAndVerifyInitializedSignature(PGPSignature signature, PGPPublicKeyRing verificationKeys, Policy policy) throws SignatureValidationException {
        CertificateValidator.validateCertificate(signature, verificationKeys, policy);
        long keyId = SignatureUtils.determineIssuerKeyId(signature);
        PGPPublicKey signingKey = verificationKeys.getPublicKey(keyId);
        SignatureVerifier.verifyInitializedSignature(signature, signingKey, policy, signature.getCreationTime());
        return true;
    }

    public static boolean validateCertificateAndVerifyOnePassSignature(OnePassSignatureCheck onePassSignature, Policy policy) throws SignatureValidationException {
        PGPSignature signature = onePassSignature.getSignature();
        CertificateValidator.validateCertificate(signature, onePassSignature.getVerificationKeys(), policy);
        PGPPublicKey signingKey = onePassSignature.getVerificationKeys().getPublicKey(signature.getKeyID());
        SignatureVerifier.verifyOnePassSignature(signature, signingKey, onePassSignature, policy);
        return true;
    }
}

