/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.exception.ModificationDetectionException;

public class IntegrityProtectedInputStream
extends InputStream {
    private final InputStream inputStream;
    private final PGPEncryptedData encryptedData;

    public IntegrityProtectedInputStream(InputStream inputStream, PGPEncryptedData encryptedData) {
        this.inputStream = inputStream;
        this.encryptedData = encryptedData;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(@Nonnull byte[] b, int offset, int length) throws IOException {
        return this.inputStream.read(b, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.encryptedData.isIntegrityProtected()) {
            try {
                if (!this.encryptedData.verify()) {
                    throw new ModificationDetectionException();
                }
            }
            catch (PGPException e) {
                throw new IOException("Failed to verify integrity protection", e);
            }
        }
    }
}

