/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.util.IntegrityProtectedInputStream;

public class DecryptionStream
extends InputStream {
    private final InputStream inputStream;
    private final OpenPgpMetadata.Builder resultBuilder;
    private boolean isClosed = false;
    private final IntegrityProtectedInputStream integrityProtectedInputStream;
    private final InputStream armorStream;

    DecryptionStream(@Nonnull InputStream wrapped, @Nonnull OpenPgpMetadata.Builder resultBuilder, IntegrityProtectedInputStream integrityProtectedInputStream, InputStream armorStream) {
        this.inputStream = wrapped;
        this.resultBuilder = resultBuilder;
        this.integrityProtectedInputStream = integrityProtectedInputStream;
        this.armorStream = armorStream;
    }

    @Override
    public int read() throws IOException {
        int r = this.inputStream.read();
        return r;
    }

    @Override
    public int read(@Nonnull byte[] bytes, int offset, int length) throws IOException {
        int read = this.inputStream.read(bytes, offset, length);
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.armorStream != null) {
            Streams.drain((InputStream)this.armorStream);
        }
        this.inputStream.close();
        if (this.integrityProtectedInputStream != null) {
            this.integrityProtectedInputStream.close();
        }
        this.isClosed = true;
    }

    public OpenPgpMetadata getResult() {
        if (!this.isClosed) {
            throw new IllegalStateException("DecryptionStream MUST be closed before the result can be accessed.");
        }
        return this.resultBuilder.build();
    }
}

