/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.SignatureValidator;
import org.pgpainless.signature.SignatureVerifier;
import org.pgpainless.util.CollectionUtils;

public final class SignaturePicker {
    private SignaturePicker() {
    }

    public static PGPSignature pickCurrentRevocationSelfSignature(PGPKeyRing keyRing, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(primaryKey, SignatureType.KEY_REVOCATION);
        PGPSignature mostCurrentValidSig = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureVerifier.verifyKeyRevocationSignature(signature, primaryKey, policy, validationDate);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            mostCurrentValidSig = signature;
        }
        return mostCurrentValidSig;
    }

    public static PGPSignature pickCurrentDirectKeySelfSignature(PGPKeyRing keyRing, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        return SignaturePicker.pickCurrentDirectKeySignature(primaryKey, primaryKey, policy, validationDate);
    }

    public static PGPSignature pickCurrentDirectKeySignature(PGPPublicKey signingKey, PGPPublicKey signedKey, Policy policy, Date validationDate) {
        List<PGPSignature> directKeySignatures = SignaturePicker.getSortedSignaturesOfType(signedKey, SignatureType.DIRECT_KEY);
        PGPSignature mostRecentDirectKeySigBySigningKey = null;
        for (PGPSignature signature : directKeySignatures) {
            try {
                SignatureVerifier.verifyDirectKeySignature(signature, signingKey, signedKey, policy, validationDate);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            mostRecentDirectKeySigBySigningKey = signature;
        }
        return mostRecentDirectKeySigBySigningKey;
    }

    public static PGPSignature pickLatestDirectKeySignature(PGPKeyRing keyRing, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        return SignaturePicker.pickLatestDirectKeySignature(primaryKey, primaryKey, policy, validationDate);
    }

    public static PGPSignature pickLatestDirectKeySignature(PGPPublicKey signingKey, PGPPublicKey signedKey, Policy policy, Date validationDate) {
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(signedKey, SignatureType.DIRECT_KEY);
        PGPSignature latestDirectKeySignature = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureValidator.signatureIsOfType(SignatureType.DIRECT_KEY).verify(signature);
                SignatureValidator.signatureStructureIsAcceptable(signingKey, policy).verify(signature);
                SignatureValidator.signatureIsAlreadyEffective(validationDate).verify(signature);
                if (latestDirectKeySignature != null && !SignatureUtils.isSignatureExpired(latestDirectKeySignature, validationDate)) {
                    SignatureValidator.signatureIsNotYetExpired(validationDate).verify(signature);
                }
                SignatureValidator.correctSignatureOverKey(signingKey, signedKey).verify(signature);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            latestDirectKeySignature = signature;
        }
        return latestDirectKeySignature;
    }

    public static PGPSignature pickCurrentUserIdRevocationSignature(PGPKeyRing keyRing, String userId, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(primaryKey, SignatureType.CERTIFICATION_REVOCATION);
        PGPSignature latestUserIdRevocation = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureVerifier.verifyUserIdRevocation(userId, signature, primaryKey, policy, validationDate);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            latestUserIdRevocation = signature;
        }
        return latestUserIdRevocation;
    }

    public static PGPSignature pickCurrentUserIdCertificationSignature(PGPKeyRing keyRing, String userId, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        Iterator userIdSigIterator = primaryKey.getSignaturesForID(userId);
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(userIdSigIterator);
        Collections.sort(signatures, new SignatureCreationDateComparator());
        PGPSignature mostRecentUserIdCertification = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureVerifier.verifyUserIdCertification(userId, signature, primaryKey, policy, validationDate);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            mostRecentUserIdCertification = signature;
        }
        return mostRecentUserIdCertification;
    }

    public static PGPSignature pickLatestUserIdCertificationSignature(PGPKeyRing keyRing, String userId, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        Iterator userIdSigIterator = primaryKey.getSignaturesForID(userId);
        List<PGPSignature> signatures = CollectionUtils.iteratorToList(userIdSigIterator);
        Collections.sort(signatures, new SignatureCreationDateComparator());
        PGPSignature latestUserIdCert = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureValidator.wasPossiblyMadeByKey(primaryKey).verify(signature);
                SignatureValidator.signatureIsCertification().verify(signature);
                SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
                SignatureValidator.signatureIsAlreadyEffective(validationDate).verify(signature);
                if (latestUserIdCert != null && !SignatureUtils.isSignatureExpired(latestUserIdCert, validationDate)) {
                    SignatureValidator.signatureIsNotYetExpired(validationDate).verify(signature);
                }
                SignatureValidator.correctSignatureOverUserId(userId, primaryKey, primaryKey).verify(signature);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            latestUserIdCert = signature;
        }
        return latestUserIdCert;
    }

    public static PGPSignature pickCurrentSubkeyBindingRevocationSignature(PGPKeyRing keyRing, PGPPublicKey subkey, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        if (primaryKey.getKeyID() == subkey.getKeyID()) {
            throw new IllegalArgumentException("Primary key cannot have subkey binding revocations.");
        }
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
        PGPSignature latestSubkeyRevocation = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureVerifier.verifySubkeyBindingRevocation(signature, primaryKey, subkey, policy, validationDate);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            latestSubkeyRevocation = signature;
        }
        return latestSubkeyRevocation;
    }

    public static PGPSignature pickCurrentSubkeyBindingSignature(PGPKeyRing keyRing, PGPPublicKey subkey, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        if (primaryKey.getKeyID() == subkey.getKeyID()) {
            throw new IllegalArgumentException("Primary key cannot have subkey binding signature.");
        }
        List<PGPSignature> subkeyBindingSigs = SignaturePicker.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
        PGPSignature mostCurrentValidSig = null;
        for (PGPSignature signature : subkeyBindingSigs) {
            try {
                SignatureVerifier.verifySubkeyBindingSignature(signature, primaryKey, subkey, policy, validationDate);
            }
            catch (SignatureValidationException validationException) {
                continue;
            }
            mostCurrentValidSig = signature;
        }
        return mostCurrentValidSig;
    }

    public static PGPSignature pickLatestSubkeyBindingSignature(PGPKeyRing keyRing, PGPPublicKey subkey, Policy policy, Date validationDate) {
        PGPPublicKey primaryKey = keyRing.getPublicKey();
        if (primaryKey.getKeyID() == subkey.getKeyID()) {
            throw new IllegalArgumentException("Primary key cannot have subkey binding signature.");
        }
        List<PGPSignature> signatures = SignaturePicker.getSortedSignaturesOfType(subkey, SignatureType.SUBKEY_BINDING);
        PGPSignature latestSubkeyBinding = null;
        for (PGPSignature signature : signatures) {
            try {
                SignatureValidator.signatureIsOfType(SignatureType.SUBKEY_BINDING).verify(signature);
                SignatureValidator.signatureStructureIsAcceptable(primaryKey, policy).verify(signature);
                SignatureValidator.signatureIsAlreadyEffective(validationDate).verify(signature);
                if (latestSubkeyBinding != null && !SignatureUtils.isSignatureExpired(latestSubkeyBinding, validationDate)) {
                    SignatureValidator.signatureIsNotYetExpired(validationDate).verify(signature);
                }
                SignatureValidator.correctSubkeyBindingSignature(primaryKey, subkey).verify(signature);
            }
            catch (SignatureValidationException e) {
                continue;
            }
            latestSubkeyBinding = signature;
        }
        return latestSubkeyBinding;
    }

    private static List<PGPSignature> getSortedSignaturesOfType(PGPPublicKey key, SignatureType type) {
        Iterator signaturesOfType = key.getSignaturesOfType(type.getCode());
        List<PGPSignature> signatureList = CollectionUtils.iteratorToList(signaturesOfType);
        Collections.sort(signatureList, new SignatureCreationDateComparator());
        return signatureList;
    }
}

