/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.util.Comparator;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.signature.SignatureCreationDateComparator;
import org.pgpainless.signature.SignatureUtils;

public class SignatureValidityComparator
implements Comparator<PGPSignature> {
    private final SignatureCreationDateComparator creationDateComparator;

    public SignatureValidityComparator() {
        this(SignatureCreationDateComparator.DEFAULT_ORDER);
    }

    public SignatureValidityComparator(SignatureCreationDateComparator.Order order) {
        this.creationDateComparator = new SignatureCreationDateComparator(order);
    }

    @Override
    public int compare(PGPSignature one, PGPSignature two) {
        boolean twoIsHard;
        boolean oneIsHard = SignatureUtils.isHardRevocation(one);
        if (oneIsHard == (twoIsHard = SignatureUtils.isHardRevocation(two))) {
            return this.creationDateComparator.compare(one, two);
        }
        return oneIsHard ? -1 : 1;
    }
}

