/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilderInterface;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.util.CollectionUtils;

public class KeySpecBuilder
implements KeySpecBuilderInterface {
    private final KeyType type;
    private final KeyFlag[] keyFlags;
    private final PGPSignatureSubpacketGenerator hashedSubPackets = new PGPSignatureSubpacketGenerator();
    private final AlgorithmSuite algorithmSuite = PGPainless.getPolicy().getKeyGenerationAlgorithmSuite();
    private Set<CompressionAlgorithm> preferredCompressionAlgorithms = this.algorithmSuite.getCompressionAlgorithms();
    private Set<HashAlgorithm> preferredHashAlgorithms = this.algorithmSuite.getHashAlgorithms();
    private Set<SymmetricKeyAlgorithm> preferredSymmetricAlgorithms = this.algorithmSuite.getSymmetricKeyAlgorithms();

    KeySpecBuilder(@Nonnull KeyType type, KeyFlag flag, KeyFlag ... flags) {
        if (flag == null) {
            throw new IllegalArgumentException("Key MUST carry at least one key flag");
        }
        if (flags == null) {
            throw new IllegalArgumentException("List of additional flags MUST NOT be null.");
        }
        flags = CollectionUtils.concat(flag, flags);
        KeySpecBuilder.assureKeyCanCarryFlags(type, flags);
        this.type = type;
        this.keyFlags = flags;
    }

    @Override
    public KeySpecBuilder overridePreferredCompressionAlgorithms(CompressionAlgorithm ... compressionAlgorithms) {
        this.preferredCompressionAlgorithms = new LinkedHashSet<CompressionAlgorithm>(Arrays.asList(compressionAlgorithms));
        return this;
    }

    @Override
    public KeySpecBuilder overridePreferredHashAlgorithms(HashAlgorithm ... preferredHashAlgorithms) {
        this.preferredHashAlgorithms = new LinkedHashSet<HashAlgorithm>(Arrays.asList(preferredHashAlgorithms));
        return this;
    }

    @Override
    public KeySpecBuilder overridePreferredSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... preferredSymmetricKeyAlgorithms) {
        this.preferredSymmetricAlgorithms = new LinkedHashSet<SymmetricKeyAlgorithm>(Arrays.asList(preferredSymmetricKeyAlgorithms));
        return this;
    }

    @Override
    public KeySpec build() {
        this.hashedSubPackets.setKeyFlags(false, KeyFlag.toBitmask(this.keyFlags));
        this.hashedSubPackets.setPreferredCompressionAlgorithms(false, this.getPreferredCompressionAlgorithmIDs());
        this.hashedSubPackets.setPreferredHashAlgorithms(false, this.getPreferredHashAlgorithmIDs());
        this.hashedSubPackets.setPreferredSymmetricAlgorithms(false, this.getPreferredSymmetricKeyAlgorithmIDs());
        this.hashedSubPackets.setFeature(false, Feature.MODIFICATION_DETECTION.getFeatureId());
        return new KeySpec(this.type, this.hashedSubPackets, false);
    }

    private int[] getPreferredCompressionAlgorithmIDs() {
        int[] ids = new int[this.preferredCompressionAlgorithms.size()];
        Iterator<CompressionAlgorithm> iterator = this.preferredCompressionAlgorithms.iterator();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return ids;
    }

    private int[] getPreferredHashAlgorithmIDs() {
        int[] ids = new int[this.preferredHashAlgorithms.size()];
        Iterator<HashAlgorithm> iterator = this.preferredHashAlgorithms.iterator();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return ids;
    }

    private int[] getPreferredSymmetricKeyAlgorithmIDs() {
        int[] ids = new int[this.preferredSymmetricAlgorithms.size()];
        Iterator<SymmetricKeyAlgorithm> iterator = this.preferredSymmetricAlgorithms.iterator();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = iterator.next().getAlgorithmId();
        }
        return ids;
    }

    private static void assureKeyCanCarryFlags(KeyType type, KeyFlag ... flags) {
        int mask = KeyFlag.toBitmask(flags);
        if (!type.canCertify() && KeyFlag.hasKeyFlag(mask, KeyFlag.CERTIFY_OTHER)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag CERTIFY_OTHER.");
        }
        if (!type.canSign() && KeyFlag.hasKeyFlag(mask, KeyFlag.SIGN_DATA)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag SIGN_DATA.");
        }
        if (!type.canEncryptCommunication() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_COMMS)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag ENCRYPT_COMMS.");
        }
        if (!type.canEncryptStorage() && KeyFlag.hasKeyFlag(mask, KeyFlag.ENCRYPT_STORAGE)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag ENCRYPT_STORAGE.");
        }
        if (!type.canAuthenticate() && KeyFlag.hasKeyFlag(mask, KeyFlag.AUTHENTICATION)) {
            throw new IllegalArgumentException("KeyType " + type.getName() + " cannot carry key flag AUTHENTIACTION.");
        }
    }
}

