/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import org.pgpainless.util.ArmorUtils;

public class KeyRingReader {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public PGPPublicKeyRing publicKeyRing(@Nonnull InputStream inputStream) throws IOException {
        return KeyRingReader.readPublicKeyRing(inputStream);
    }

    public PGPPublicKeyRing publicKeyRing(@Nonnull byte[] bytes) throws IOException {
        return this.publicKeyRing(new ByteArrayInputStream(bytes));
    }

    public PGPPublicKeyRing publicKeyRing(@Nonnull String asciiArmored) throws IOException {
        return this.publicKeyRing(asciiArmored.getBytes(UTF8));
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return KeyRingReader.readPublicKeyRingCollection(inputStream);
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull byte[] bytes) throws IOException, PGPException {
        return this.publicKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    public PGPPublicKeyRingCollection publicKeyRingCollection(@Nonnull String asciiArmored) throws IOException, PGPException {
        return this.publicKeyRingCollection(asciiArmored.getBytes(UTF8));
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull InputStream inputStream) throws IOException {
        return KeyRingReader.readSecretKeyRing(inputStream);
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull byte[] bytes) throws IOException {
        return this.secretKeyRing(new ByteArrayInputStream(bytes));
    }

    public PGPSecretKeyRing secretKeyRing(@Nonnull String asciiArmored) throws IOException {
        return this.secretKeyRing(asciiArmored.getBytes(UTF8));
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        return KeyRingReader.readSecretKeyRingCollection(inputStream);
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull byte[] bytes) throws IOException, PGPException {
        return this.secretKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    public PGPSecretKeyRingCollection secretKeyRingCollection(@Nonnull String asciiArmored) throws IOException, PGPException {
        return this.secretKeyRingCollection(asciiArmored.getBytes(UTF8));
    }

    public PGPKeyRingCollection keyRingCollection(@Nonnull InputStream inputStream, boolean isSilent) throws IOException, PGPException {
        return KeyRingReader.readKeyRingCollection(inputStream, isSilent);
    }

    public PGPKeyRingCollection keyRingCollection(@Nonnull byte[] bytes, boolean isSilent) throws IOException, PGPException {
        return this.keyRingCollection(new ByteArrayInputStream(bytes), isSilent);
    }

    public PGPKeyRingCollection keyRingCollection(@Nonnull String asciiArmored, boolean isSilent) throws IOException, PGPException {
        return this.keyRingCollection(asciiArmored.getBytes(UTF8), isSilent);
    }

    public static PGPPublicKeyRing readPublicKeyRing(@Nonnull InputStream inputStream) throws IOException {
        Object next;
        PGPObjectFactory objectFactory = new PGPObjectFactory(ArmorUtils.getDecoderStream(inputStream), ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        do {
            if ((next = objectFactory.nextObject()) != null) continue;
            return null;
        } while (next instanceof PGPMarker || !(next instanceof PGPPublicKeyRing));
        return (PGPPublicKeyRing)next;
    }

    /*
     * Unable to fully structure code
     */
    public static PGPPublicKeyRingCollection readPublicKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        objectFactory = new PGPObjectFactory(ArmorUtils.getDecoderStream(inputStream), ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        rings = new ArrayList<PGPPublicKeyRing>();
        block0: while (true) {
            if ((next = objectFactory.nextObject()) == null) {
                return new PGPPublicKeyRingCollection(rings);
            }
            if (next instanceof PGPMarker) continue;
            if (next instanceof PGPPublicKeyRing) {
                rings.add((PGPPublicKeyRing)next);
            }
            if (!(next instanceof PGPPublicKeyRingCollection)) continue;
            collection = (PGPPublicKeyRingCollection)next;
            iterator = collection.getKeyRings();
            while (true) {
                if (iterator.hasNext()) ** break;
                continue block0;
                rings.add((PGPPublicKeyRing)iterator.next());
            }
            break;
        }
    }

    public static PGPSecretKeyRing readSecretKeyRing(@Nonnull InputStream inputStream) throws IOException {
        Object next;
        InputStream decoderStream = ArmorUtils.getDecoderStream(inputStream);
        PGPObjectFactory objectFactory = new PGPObjectFactory(decoderStream, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        do {
            if ((next = objectFactory.nextObject()) != null) continue;
            return null;
        } while (next instanceof PGPMarker || !(next instanceof PGPSecretKeyRing));
        Streams.drain((InputStream)decoderStream);
        return (PGPSecretKeyRing)next;
    }

    /*
     * Unable to fully structure code
     */
    public static PGPSecretKeyRingCollection readSecretKeyRingCollection(@Nonnull InputStream inputStream) throws IOException, PGPException {
        objectFactory = new PGPObjectFactory(ArmorUtils.getDecoderStream(inputStream), ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        rings = new ArrayList<PGPSecretKeyRing>();
        block0: while (true) {
            if ((next = objectFactory.nextObject()) == null) {
                return new PGPSecretKeyRingCollection(rings);
            }
            if (next instanceof PGPMarker) continue;
            if (next instanceof PGPSecretKeyRing) {
                rings.add((PGPSecretKeyRing)next);
            }
            if (!(next instanceof PGPSecretKeyRingCollection)) continue;
            collection = (PGPSecretKeyRingCollection)next;
            iterator = collection.getKeyRings();
            while (true) {
                if (iterator.hasNext()) ** break;
                continue block0;
                rings.add((PGPSecretKeyRing)iterator.next());
            }
            break;
        }
    }

    public static PGPKeyRingCollection readKeyRingCollection(@Nonnull InputStream inputStream, boolean isSilent) throws IOException, PGPException {
        return new PGPKeyRingCollection(inputStream, isSilent);
    }
}

