/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;

public final class OpenPgpKeyAttributeUtil {
    private OpenPgpKeyAttributeUtil() {
    }

    public static List<HashAlgorithm> getPreferredHashAlgorithms(PGPPublicKey publicKey) {
        ArrayList<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>();
        Iterator keySignatures = publicKey.getSignatures();
        while (keySignatures.hasNext()) {
            int[] hashAlgos;
            SignatureType signatureType;
            PGPSignature signature = (PGPSignature)keySignatures.next();
            if (signature.getKeyID() != publicKey.getKeyID() || (signatureType = SignatureType.valueOf(signature.getSignatureType())) != SignatureType.POSITIVE_CERTIFICATION && signatureType != SignatureType.GENERIC_CERTIFICATION || (hashAlgos = signature.getHashedSubPackets().getPreferredHashAlgorithms()) == null) continue;
            for (int h : hashAlgos) {
                hashAlgorithms.add(HashAlgorithm.fromId(h));
            }
        }
        return hashAlgorithms;
    }

    public static List<HashAlgorithm> guessPreferredHashAlgorithms(PGPPublicKey publicKey) {
        HashAlgorithm hashAlgorithm = null;
        Date lastCreationDate = null;
        Iterator keySignatures = publicKey.getSignatures();
        while (keySignatures.hasNext()) {
            SignatureType signatureType;
            PGPSignature signature = (PGPSignature)keySignatures.next();
            if (signature.getKeyID() != publicKey.getKeyID() || (signatureType = SignatureType.valueOf(signature.getSignatureType())) != SignatureType.POSITIVE_CERTIFICATION && signatureType != SignatureType.GENERIC_CERTIFICATION) continue;
            Date creationDate = signature.getCreationTime();
            if (lastCreationDate != null && !lastCreationDate.before(creationDate)) continue;
            lastCreationDate = creationDate;
            hashAlgorithm = HashAlgorithm.fromId(signature.getHashAlgorithm());
        }
        if (hashAlgorithm == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(hashAlgorithm);
    }
}

