/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.decryption_verification.MessageInspector;
import org.pgpainless.key.util.KeyIdUtil;

public class MessageInspectorTest {
    @Test
    public void testBasicMessageInspection() throws PGPException, IOException {
        String message = "-----BEGIN PGP MESSAGE-----\n\nwV4DR2b2udXyHrYSAQdAO6LtuB8LenDp1EPVSSYn1QCmTSPjeXj9Qdel7t6Ozi8w\nkewS+0AdZcvcd2PQEuCboilRAN4TTi9SziuSDNZe//suYHL7SRnOvX6mWSZoiKBm\n0j8BlbKlRhBzcNDj6DSKfM/KBhRaw0U9fGs01gq+RNXIHOOnzVjLK18xTNEkx72F\nZ1/i3TYsmy8B0mMKkNYtpMk=\n=IICf\n-----END PGP MESSAGE-----\n";
        MessageInspector.EncryptionInfo info = MessageInspector.determineEncryptionInfoForMessage((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertFalse((boolean)info.isPassphraseEncrypted());
        Assertions.assertFalse((boolean)info.isSignedOnly());
        Assertions.assertTrue((boolean)info.isEncrypted());
        Assertions.assertEquals((int)1, (int)info.getKeyIds().size());
        Assertions.assertEquals((long)KeyIdUtil.fromLongKeyId((String)"4766F6B9D5F21EB6"), (Long)((Long)info.getKeyIds().get(0)));
    }

    @Test
    public void testMultipleRecipientKeysAndPassphrase() throws PGPException, IOException {
        String message = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\njC4ECQMCtjbxGuer3wJgmQNX6L5nrJzkOEsnsFxyDYmqpqaFaMRHwARfX2huZdNd\nhF4DTG6PmfbkcYQSAQdAxolEEp+NDhQXzf4/hN/4ihjSs16EoMVPxnQVZslvXm0w\npCmY/zAd1i3cJjNw2IXtCUpAIwjGc3pJzPxnkm0aBSS1ejxTqKy34MlostqEveB+\nhF4DGDkHmmQLL6wSAQdAxdIJmu7Vbz12eG3lCUDuuwXW1s0ZsSftbUT3Ly+YMFIw\nTadDYpy4pAAC82G8Z291zMiyctJE5dPAEWE5/sIguJSTeeM3ltocCMfx3ZCbKiov\njC4ECQMCssbl4ymUB6FgAVELIUXGolY6PgsnRmq3oBQbM7ysu+WsXm//CRXqfkgU\n0kABN21rVlCCSrgAQq2vY4GWQ8OfiUzJOWH//63VDYMJ5ehou9eFtOXq2YW9IUy4\nnxVuXey3iyihCFAfD8ZK1Rnh\n=z6e0\n-----END PGP MESSAGE-----";
        MessageInspector.EncryptionInfo info = MessageInspector.determineEncryptionInfoForMessage((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertTrue((boolean)info.isEncrypted());
        Assertions.assertTrue((boolean)info.isPassphraseEncrypted());
        Assertions.assertEquals((int)2, (int)info.getKeyIds().size());
        Assertions.assertFalse((boolean)info.isSignedOnly());
        Assertions.assertTrue((boolean)info.getKeyIds().contains(KeyIdUtil.fromLongKeyId((String)"4C6E8F99F6E47184")));
        Assertions.assertTrue((boolean)info.getKeyIds().contains(KeyIdUtil.fromLongKeyId((String)"1839079A640B2FAC")));
    }

    @Test
    public void testSignedOnlyMessage() throws PGPException, IOException {
        String message = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nowGbwMvMwCU2JftV+VJxWRbG0yJJDCDgkZqTk6+jEJ5flJOiyNVRysIgxsXAxsqU\nGPbzCoMipwBMg5giy+9JdusX5zywTwq60QsTfj2J4a9ki6nKuVnu940q5qzl+aK3\n89zdHzzyDBEdJg4asQcf3PBk+Cu1W/vQ1mMVW3fyTVc0VNe9PyktZlfcge2CbR8F\nDvxwv8UPAA==\n=nt5n\n-----END PGP MESSAGE-----";
        MessageInspector.EncryptionInfo info = MessageInspector.determineEncryptionInfoForMessage((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertTrue((boolean)info.isSignedOnly());
        Assertions.assertFalse((boolean)info.isEncrypted());
        Assertions.assertFalse((boolean)info.isPassphraseEncrypted());
        Assertions.assertEquals((int)0, (int)info.getKeyIds().size());
    }

    @Test
    public void testEncryptedAndSignedMessage() throws PGPException, IOException {
        String message = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\njC4ECQMCKFdrpiMTt8xgtZjkH60Nu4s+5THbPWOgyTmXkAeBAsmXDNWWuB5QSXFz\nhF4DaM8R0fnHE6USAQdALJl6fCtB597Ub/GR3bxu3Uv2lirMA8bI2iGHUE7f0Rkw\nZNgmEk3YRGp+zddZoLp0WAIL0y4FLwUlMrR+YFYA37eAILiCwLEesIpvIoYq+fIu\n0r4BJ/bM9oiCZGy7clpBQgOBFOTMR2fCO9ESVOaLwTGDJkVk6m+iLV1OYG6997vP\nqHrg/zzy/U+xm90iHJzXoQ7yd2QZMU7llvC/otf5j14x3PCqd/rIxQrO2uc76Pef\nLh1JRHb7St4PC429HfE7pEAfFUej1I56U/ZCPwxa9f6je911jM4ZmZQTKJq3XZ3H\nKK0Ymg5GrsBTEGFm4jb1p+V85PPhsIioX3np/N3fkIfxFguTGZza33/GHy61+DTy\n=SZU6\n-----END PGP MESSAGE-----";
        MessageInspector.EncryptionInfo info = MessageInspector.determineEncryptionInfoForMessage((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertFalse((boolean)info.isSignedOnly());
        Assertions.assertTrue((boolean)info.isEncrypted());
        Assertions.assertTrue((boolean)info.isPassphraseEncrypted());
        Assertions.assertEquals((int)1, (int)info.getKeyIds().size());
    }
}

