/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.provider.ProviderFactory;

public class BouncycastleExportSubkeys {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testExportImport(ImplementationFactory implementationFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        KeyPairGenerator generator = KeyPairGenerator.getInstance("ECDSA", ProviderFactory.getProvider());
        generator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair pair = generator.generateKeyPair();
        JcaPGPKeyPair pgpMasterKey = new JcaPGPKeyPair(19, pair, new Date());
        PGPSignatureSubpacketGenerator subPackets = new PGPSignatureSubpacketGenerator();
        subPackets.setKeyFlags(false, 0);
        subPackets.setPreferredCompressionAlgorithms(false, new int[]{9, 7, 7});
        subPackets.setPreferredHashAlgorithms(false, new int[]{10, 9, 8, 11});
        subPackets.setPreferredCompressionAlgorithms(false, new int[]{2, 3, 1, 0});
        subPackets.setFeature(false, (byte)1);
        generator = KeyPairGenerator.getInstance("ECDH", ProviderFactory.getProvider());
        generator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        pair = generator.generateKeyPair();
        JcaPGPKeyPair pgpSubKey = new JcaPGPKeyPair(18, pair, new Date());
        PGPDigestCalculator calculator = new JcaPGPDigestCalculatorProviderBuilder().setProvider(ProviderFactory.getProvider()).build().get(2);
        JcaPGPContentSignerBuilder signerBuilder = new JcaPGPContentSignerBuilder(pgpMasterKey.getPublicKey().getAlgorithm(), 10).setProvider(ProviderFactory.getProvider());
        PGPKeyRingGenerator pgpGenerator = new PGPKeyRingGenerator(19, (PGPKeyPair)pgpMasterKey, "alice@wonderland.lit", calculator, subPackets.generate(), null, (PGPContentSignerBuilder)signerBuilder, null);
        subPackets.setKeyFlags(false, 0);
        pgpGenerator.addSubKey((PGPKeyPair)pgpSubKey, subPackets.generate(), null);
        PGPSecretKeyRing secretKeys = pgpGenerator.generateSecretKeyRing();
        PGPPublicKeyRing publicKeys = pgpGenerator.generatePublicKeyRing();
    }
}

