/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.TestKeys;

public class SubkeyIdentifierTest {
    private static PGPPublicKeyRing CERT;
    private static final OpenPgpV4Fingerprint PRIMARY_FP;
    private static final OpenPgpV4Fingerprint SUBKEY_FP;

    @BeforeAll
    public static void setup() throws IOException {
        CERT = TestKeys.getEmilPublicKeyRing();
    }

    @Test
    public void fromKeyRing() {
        SubkeyIdentifier identifier = new SubkeyIdentifier((PGPKeyRing)CERT);
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getPrimaryKeyFingerprint());
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getSubkeyFingerprint());
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getFingerprint());
    }

    @Test
    public void fromKeyRingAndSubkeyId() {
        SubkeyIdentifier identifier = new SubkeyIdentifier((PGPKeyRing)CERT, SUBKEY_FP);
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getPrimaryKeyFingerprint());
        Assertions.assertEquals((Object)SUBKEY_FP, (Object)identifier.getSubkeyFingerprint());
        Assertions.assertEquals((Object)SUBKEY_FP, (Object)identifier.getFingerprint());
    }

    @Test
    public void fromFingerprints() {
        SubkeyIdentifier identifier = new SubkeyIdentifier(PRIMARY_FP, SUBKEY_FP);
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getPrimaryKeyFingerprint());
        Assertions.assertEquals((Object)SUBKEY_FP, (Object)identifier.getSubkeyFingerprint());
        Assertions.assertEquals((Object)SUBKEY_FP, (Object)identifier.getFingerprint());
    }

    @Test
    public void fromFingerprint() {
        SubkeyIdentifier identifier = new SubkeyIdentifier(PRIMARY_FP);
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getFingerprint());
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getSubkeyFingerprint());
        Assertions.assertEquals((Object)PRIMARY_FP, (Object)identifier.getPrimaryKeyFingerprint());
    }

    @Test
    public void testGetKeyIds() {
        SubkeyIdentifier identifier = new SubkeyIdentifier((PGPKeyRing)CERT, SUBKEY_FP);
        Assertions.assertEquals((long)PRIMARY_FP.getKeyId(), (long)identifier.getPrimaryKeyId());
        Assertions.assertEquals((long)SUBKEY_FP.getKeyId(), (long)identifier.getKeyId());
        Assertions.assertEquals((long)SUBKEY_FP.getKeyId(), (long)identifier.getSubkeyId());
    }

    @Test
    public void toStringTest() {
        SubkeyIdentifier identifier = new SubkeyIdentifier((PGPKeyRing)CERT, SUBKEY_FP);
        Assertions.assertEquals((Object)"F73FDE6439ABE210B1AF4EDD273EF7A0C749807B 4F665C4DC2C4660BC6425E415736E6931ACF370C", (Object)identifier.toString());
    }

    @Test
    public void testEquals() {
        SubkeyIdentifier id1 = new SubkeyIdentifier((PGPKeyRing)CERT, SUBKEY_FP);
        SubkeyIdentifier id2 = new SubkeyIdentifier(PRIMARY_FP, SUBKEY_FP);
        Assertions.assertEquals((Object)id1, (Object)id1);
        Assertions.assertEquals((Object)id1, (Object)id2);
        Assertions.assertEquals((int)id1.hashCode(), (int)id2.hashCode());
    }

    @Test
    public void testNotEquals() {
        SubkeyIdentifier id1 = new SubkeyIdentifier((PGPKeyRing)CERT, SUBKEY_FP);
        SubkeyIdentifier id2 = new SubkeyIdentifier(PRIMARY_FP);
        SubkeyIdentifier id3 = new SubkeyIdentifier(SUBKEY_FP);
        Assertions.assertNotEquals((Object)id1, (Object)id2);
        Assertions.assertNotEquals((Object)id2, (Object)id3);
        Assertions.assertNotEquals((Object)id1, (Object)id3);
        Assertions.assertNotEquals((Object)id1, (Object)PRIMARY_FP);
        Assertions.assertNotEquals((Object)id1, null);
    }

    @Test
    public void nonExistentSubkeyThrowsNoSuchElementException() {
        Assertions.assertThrows(NoSuchElementException.class, () -> new SubkeyIdentifier((PGPKeyRing)CERT, 123L));
    }

    static {
        PRIMARY_FP = new OpenPgpV4Fingerprint("4F665C4DC2C4660BC6425E415736E6931ACF370C");
        SUBKEY_FP = new OpenPgpV4Fingerprint("F73FDE6439ABE210B1AF4EDD273EF7A0C749807B");
    }
}

