/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;

public class CertificationKeyMustBeAbleToCertifyTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testCertificationIncapableKeyTypesThrow(ImplementationFactory implementationFactory) {
        KeyType[] typesIncapableOfCreatingVerifications;
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        for (KeyType type : typesIncapableOfCreatingVerifications = new KeyType[]{KeyType.ECDH((EllipticCurve)EllipticCurve._P256), KeyType.ECDH((EllipticCurve)EllipticCurve._P384), KeyType.ECDH((EllipticCurve)EllipticCurve._P521), KeyType.XDH((XDHSpec)XDHSpec._X25519)}) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((KeyRingBuilder)PGPainless.generateKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)type, (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addUserId("should@throw.ex").build());
        }
    }
}

