/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.key.util.UserId;

public class GenerateEllipticCurveKeyTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void generateEllipticCurveKeys(ImplementationFactory implementationFactory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing keyRing = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.generateKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[0]))).addUserId(UserId.onlyEmail((String)"alice@wonderland.lit").toString()).build();
        Assertions.assertEquals((int)PublicKeyAlgorithm.EDDSA.getAlgorithmId(), (int)keyRing.getPublicKey().getAlgorithm());
    }
}

