/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.UserId;
import org.pgpainless.util.DateUtil;

public class GenerateKeyWithAdditionalUserIdTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void test(ImplementationFactory implementationFactory) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        Date expiration = new Date(DateUtil.now().getTime() + 60000L);
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.generateKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.RSA((RsaLength)RsaLength._3072), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS}))).addUserId(UserId.onlyEmail((String)"primary@user.id"))).addUserId(UserId.onlyEmail((String)"additional@user.id"))).addUserId(UserId.onlyEmail((String)"additional2@user.id"))).addUserId("\ttrimThis@user.id     ").setExpirationDate(expiration).build();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)secretKeys);
        JUtils.assertEquals(expiration.getTime(), PGPainless.inspectKeyRing((PGPKeyRing)publicKeys).getPrimaryKeyExpirationDate().getTime(), 2000L);
        Iterator userIds = publicKeys.getPublicKey().getUserIDs();
        Assertions.assertEquals((Object)"primary@user.id", userIds.next());
        Assertions.assertEquals((Object)"additional@user.id", userIds.next());
        Assertions.assertEquals((Object)"additional2@user.id", userIds.next());
        Assertions.assertEquals((Object)"trimThis@user.id", userIds.next());
        Assertions.assertFalse((boolean)userIds.hasNext());
    }
}

