/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;

public class IllegalKeyFlagsTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testKeyCannotCarryFlagsTest(ImplementationFactory implementationFactory) {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.SIGN_DATA, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.AUTHENTICATION, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.ENCRYPT_STORAGE, (KeyFlag[])new KeyFlag[0]));
    }
}

