/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.Passphrase;

public class PassphraseTest {
    @Test
    public void testGetAndClear() {
        Passphrase passphrase = new Passphrase("secret".toCharArray());
        Assertions.assertArrayEquals((char[])"secret".toCharArray(), (char[])passphrase.getChars());
        Assertions.assertTrue((boolean)passphrase.isValid());
        passphrase.clear();
        Assertions.assertFalse((boolean)passphrase.isValid());
        Assertions.assertThrows(IllegalStateException.class, () -> ((Passphrase)passphrase).getChars());
    }

    @Test
    public void testTrimming() {
        Passphrase leadingSpace = Passphrase.fromPassword((String)" space");
        Assertions.assertArrayEquals((char[])"space".toCharArray(), (char[])leadingSpace.getChars());
        Assertions.assertFalse((boolean)leadingSpace.isEmpty());
        Passphrase trailingSpace = Passphrase.fromPassword((String)"space ");
        Assertions.assertArrayEquals((char[])"space".toCharArray(), (char[])trailingSpace.getChars());
        Assertions.assertFalse((boolean)trailingSpace.isEmpty());
        Passphrase leadingTrailingWhitespace = new Passphrase("\t Such whitespace, much wow\n ".toCharArray());
        Assertions.assertArrayEquals((char[])"Such whitespace, much wow".toCharArray(), (char[])leadingTrailingWhitespace.getChars());
        Assertions.assertFalse((boolean)leadingTrailingWhitespace.isEmpty());
        Passphrase fromEmptyChars = new Passphrase("     ".toCharArray());
        Assertions.assertNull((Object)fromEmptyChars.getChars());
        Assertions.assertTrue((boolean)fromEmptyChars.isEmpty());
    }

    @Test
    public void testEmptyPassphrase() {
        Passphrase empty = Passphrase.emptyPassphrase();
        Assertions.assertNull((Object)empty.getChars());
        Assertions.assertTrue((boolean)empty.isEmpty());
        Passphrase trimmedEmpty = Passphrase.fromPassword((String)"    ");
        Assertions.assertNull((Object)trimmedEmpty.getChars());
        Assertions.assertTrue((boolean)trimmedEmpty.isEmpty());
    }

    @Test
    public void equalsTest() {
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((String)"passphrase"), (Object)Passphrase.fromPassword((String)"Password"));
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((String)"password"), null);
        Assertions.assertNotEquals((Object)Passphrase.fromPassword((String)"password"), (Object)"password");
        Passphrase passphrase = Passphrase.fromPassword((String)"passphrase");
        Assertions.assertEquals((Object)passphrase, (Object)passphrase);
    }

    @Test
    public void hashCodeTest() {
        Assertions.assertNotEquals((int)0, (int)Passphrase.fromPassword((String)"passphrase").hashCode());
        Assertions.assertNotEquals((int)Passphrase.fromPassword((String)"passphrase").hashCode(), (int)Passphrase.fromPassword((String)"password").hashCode());
        Assertions.assertEquals((int)0, (int)Passphrase.emptyPassphrase().hashCode());
    }
}

