/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class SecretKeyRingProtectorTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testUnlockAllKeysWithSamePassword(ImplementationFactory implementationFactory) throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockAllKeysWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKeyRing)secretKeys);
        for (PGPSecretKey secretKey : secretKeys) {
            PBESecretKeyDecryptor decryptor = protector.getDecryptor(Long.valueOf(secretKey.getKeyID()));
            Assertions.assertNotNull((Object)decryptor);
            secretKey.extractPrivateKey(decryptor);
        }
        PGPSecretKeyRing unrelatedKeys = PGPainless.generateKeyRing().simpleEcKeyRing("unrelated", "SecurePassword");
        for (PGPSecretKey unrelatedKey : unrelatedKeys) {
            PBESecretKeyDecryptor decryptor = protector.getDecryptor(Long.valueOf(unrelatedKey.getKeyID()));
            Assertions.assertNull((Object)decryptor);
            Assertions.assertThrows(PGPException.class, () -> unrelatedKey.extractPrivateKey(protector.getDecryptor(Long.valueOf(unrelatedKey.getKeyID()))));
        }
    }

    @Test
    public void testUnprotectedKeys() throws PGPException {
        Random random = new Random();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        for (int i = 0; i < 10; ++i) {
            Long keyId = random.nextLong();
            Assertions.assertNull((Object)protector.getEncryptor(keyId));
            Assertions.assertNull((Object)protector.getDecryptor(keyId));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testUnlockSingleKeyWithPassphrase(ImplementationFactory implementationFactory) throws IOException, PGPException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getCryptieSecretKeyRing();
        Iterator iterator = secretKeys.iterator();
        PGPSecretKey secretKey = (PGPSecretKey)iterator.next();
        PGPSecretKey subKey = (PGPSecretKey)iterator.next();
        SecretKeyRingProtector protector = SecretKeyRingProtector.unlockSingleKeyWith((Passphrase)TestKeys.CRYPTIE_PASSPHRASE, (PGPSecretKey)secretKey);
        Assertions.assertNotNull((Object)protector.getDecryptor(Long.valueOf(secretKey.getKeyID())));
        Assertions.assertNotNull((Object)protector.getEncryptor(Long.valueOf(secretKey.getKeyID())));
        Assertions.assertNull((Object)protector.getEncryptor(Long.valueOf(subKey.getKeyID())));
        Assertions.assertNull((Object)protector.getDecryptor(Long.valueOf(subKey.getKeyID())));
    }

    @Test
    public void testFromPassphraseMap() {
        ConcurrentHashMap<Long, Passphrase> passphraseMap = new ConcurrentHashMap<Long, Passphrase>();
        passphraseMap.put(1L, Passphrase.emptyPassphrase());
        CachingSecretKeyRingProtector protector = (CachingSecretKeyRingProtector)SecretKeyRingProtector.fromPassphraseMap(passphraseMap);
        Assertions.assertNotNull((Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertNull((Object)protector.getPassphraseFor(Long.valueOf(5L)));
        protector.addPassphrase(Long.valueOf(5L), Passphrase.fromPassword((String)"pa55w0rd"));
        protector.forgetPassphrase(Long.valueOf(1L));
        Assertions.assertNull((Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertNotNull((Object)protector.getPassphraseFor(Long.valueOf(5L)));
    }

    @Test
    public void testMissingPassphraseCallback() {
        ConcurrentHashMap<Long, Passphrase> passphraseMap = new ConcurrentHashMap<Long, Passphrase>();
        passphraseMap.put(1L, Passphrase.emptyPassphrase());
        CachingSecretKeyRingProtector protector = new CachingSecretKeyRingProtector(passphraseMap, KeyRingProtectionSettings.secureDefaultSettings(), new SecretKeyPassphraseProvider(){

            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                return Passphrase.fromPassword((String)"missingP455w0rd");
            }

            public boolean hasPassphrase(Long keyId) {
                return true;
            }
        });
        Assertions.assertEquals((Object)Passphrase.emptyPassphrase(), (Object)protector.getPassphraseFor(Long.valueOf(1L)));
        Assertions.assertEquals((Object)Passphrase.fromPassword((String)"missingP455w0rd"), (Object)protector.getPassphraseFor(Long.valueOf(3L)));
    }
}

