/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVectorGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignatureVerifier;

public class SignatureOverUserAttributesTest {
    private static final byte[] image = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 1, 1, 44, 1, 44, 0, 0, -1, -2, 0, 19, 67, 114, 101, 97, 116, 101, 100, 32, 119, 105, 116, 104, 32, 71, 73, 77, 80, -1, -30, 2, -80, 73, 67, 67, 95, 80, 82, 79, 70, 73, 76, 69, 0, 1, 1, 0, 0, 2, -96, 108, 99, 109, 115, 4, 48, 0, 0, 109, 110, 116, 114, 82, 71, 66, 32, 88, 89, 90, 32, 7, -27, 0, 10, 0, 4, 0, 12, 0, 27, 0, 19, 97, 99, 115, 112, 65, 80, 80, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -10, -42, 0, 1, 0, 0, 0, 0, -45, 45, 108, 99, 109, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 100, 101, 115, 99, 0, 0, 1, 32, 0, 0, 0, 64, 99, 112, 114, 116, 0, 0, 1, 96, 0, 0, 0, 54, 119, 116, 112, 116, 0, 0, 1, -104, 0, 0, 0, 20, 99, 104, 97, 100, 0, 0, 1, -84, 0, 0, 0, 44, 114, 88, 89, 90, 0, 0, 1, -40, 0, 0, 0, 20, 98, 88, 89, 90, 0, 0, 1, -20, 0, 0, 0, 20, 103, 88, 89, 90, 0, 0, 2, 0, 0, 0, 0, 20, 114, 84, 82, 67, 0, 0, 2, 20, 0, 0, 0, 32, 103, 84, 82, 67, 0, 0, 2, 20, 0, 0, 0, 32, 98, 84, 82, 67, 0, 0, 2, 20, 0, 0, 0, 32, 99, 104, 114, 109, 0, 0, 2, 52, 0, 0, 0, 36, 100, 109, 110, 100, 0, 0, 2, 88, 0, 0, 0, 36, 100, 109, 100, 100, 0, 0, 2, 124, 0, 0, 0, 36, 109, 108, 117, 99, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 101, 110, 85, 83, 0, 0, 0, 36, 0, 0, 0, 28, 0, 71, 0, 73, 0, 77, 0, 80, 0, 32, 0, 98, 0, 117, 0, 105, 0, 108, 0, 116, 0, 45, 0, 105, 0, 110, 0, 32, 0, 115, 0, 82, 0, 71, 0, 66, 109, 108, 117, 99, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 101, 110, 85, 83, 0, 0, 0, 26, 0, 0, 0, 28, 0, 80, 0, 117, 0, 98, 0, 108, 0, 105, 0, 99, 0, 32, 0, 68, 0, 111, 0, 109, 0, 97, 0, 105, 0, 110, 0, 0, 88, 89, 90, 32, 0, 0, 0, 0, 0, 0, -10, -42, 0, 1, 0, 0, 0, 0, -45, 45, 115, 102, 51, 50, 0, 0, 0, 0, 0, 1, 12, 66, 0, 0, 5, -34, -1, -1, -13, 37, 0, 0, 7, -109, 0, 0, -3, -112, -1, -1, -5, -95, -1, -1, -3, -94, 0, 0, 3, -36, 0, 0, -64, 110, 88, 89, 90, 32, 0, 0, 0, 0, 0, 0, 111, -96, 0, 0, 56, -11, 0, 0, 3, -112, 88, 89, 90, 32, 0, 0, 0, 0, 0, 0, 36, -97, 0, 0, 15, -124, 0, 0, -74, -60, 88, 89, 90, 32, 0, 0, 0, 0, 0, 0, 98, -105, 0, 0, -73, -121, 0, 0, 24, -39, 112, 97, 114, 97, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, 102, 102, 0, 0, -14, -89, 0, 0, 13, 89, 0, 0, 19, -48, 0, 0, 10, 91, 99, 104, 114, 109, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, -93, -41, 0, 0, 84, 124, 0, 0, 76, -51, 0, 0, -103, -102, 0, 0, 38, 103, 0, 0, 15, 92, 109, 108, 117, 99, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 101, 110, 85, 83, 0, 0, 0, 8, 0, 0, 0, 28, 0, 71, 0, 73, 0, 77, 0, 80, 109, 108, 117, 99, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 12, 101, 110, 85, 83, 0, 0, 0, 8, 0, 0, 0, 28, 0, 115, 0, 82, 0, 71, 0, 66, -1, -37, 0, 67, 0, 16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99, -1, -37, 0, 67, 1, 17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, -1, -62, 0, 17, 8, 0, 16, 0, 16, 3, 1, 17, 0, 2, 17, 1, 3, 17, 1, -1, -60, 0, 22, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 5, -1, -60, 0, 20, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -38, 0, 12, 3, 1, 0, 2, 16, 3, 16, 0, 0, 1, -46, 4, -127, -1, -60, 0, 23, 16, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 2, 18, -1, -38, 0, 8, 1, 1, 0, 1, 5, 2, 100, -99, -118, 78, -44, -18, -100, -114, -27, -1, 0, -1, -60, 0, 20, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -1, -38, 0, 8, 1, 3, 1, 1, 63, 1, 31, -1, -60, 0, 20, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -1, -38, 0, 8, 1, 2, 1, 1, 63, 1, 31, -1, -60, 0, 31, 16, 0, 1, 1, 9, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 17, 18, 33, 49, 81, 113, -111, -47, 3, -1, -38, 0, 8, 1, 1, 0, 6, 63, 2, 30, 111, 55, 107, 8, -80, -13, 118, 112, -88, 97, 32, 79, 125, 84, 48, -128, 103, -82, 47, -1, -60, 0, 28, 16, 1, 0, 2, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 17, 33, 49, 65, 81, 113, -127, -1, -38, 0, 8, 1, 1, 0, 1, 63, 33, 50, -128, -43, 26, -84, -73, -18, 56, 104, 106, -83, -34, 27, -9, 26, 113, -125, -59, 65, 78, 112, 120, -88, -1, -38, 0, 12, 3, 1, 0, 2, 0, 3, 0, 0, 0, 16, 0, 15, -1, -60, 0, 20, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -1, -38, 0, 8, 1, 3, 1, 1, 63, 16, 31, -1, -60, 0, 20, 17, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -1, -38, 0, 8, 1, 2, 1, 1, 63, 16, 31, -1, -60, 0, 25, 16, 1, 1, 0, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 17, 0, 33, 49, 65, -1, -38, 0, 8, 1, 1, 0, 1, 63, 16, -107, 3, 101, -86, 14, -55, 65, -18, 74, -95, -78, -43, 15, 109, -119, -9, 27, -42, -76, -70, 80, 69, -91, -27, 115, -61, 27, -62, -108, -70, 20, 1, -95, -27, 115, -41, 63, -1, -39};
    private static PGPUserAttributeSubpacketVector attribute;
    private static PGPUserAttributeSubpacketVector invalidAttribute;

    @Test
    public void createAndVerifyUserAttributeCertification() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPSecretKey secretKey = secretKeys.getSecretKey();
        PGPPublicKey publicKey = secretKey.getPublicKey();
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        generator.init(SignatureType.CASUAL_CERTIFICATION.getCode(), privateKey);
        PGPSignature signature = generator.generateCertification(attribute, publicKey);
        publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPUserAttributeSubpacketVector)attribute, (PGPSignature)signature);
        SignatureVerifier.verifyUserAttributesCertification((PGPUserAttributeSubpacketVector)attribute, (PGPSignature)signature, (PGPPublicKey)publicKey, (Policy)PGPainless.getPolicy(), (Date)new Date());
        PGPPublicKey finalPublicKey = publicKey;
        Assertions.assertThrows(SignatureValidationException.class, () -> SignatureVerifier.verifyUserAttributesCertification((PGPUserAttributeSubpacketVector)invalidAttribute, (PGPSignature)signature, (PGPPublicKey)finalPublicKey, (Policy)PGPainless.getPolicy(), (Date)new Date()));
    }

    @Test
    public void createAndVerifyUserAttributeRevocation() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        PGPSecretKey secretKey = secretKeys.getSecretKey();
        PGPPublicKey publicKey = secretKey.getPublicKey();
        PGPPrivateKey privateKey = UnlockSecretKey.unlockSecretKey((PGPSecretKey)secretKey, (SecretKeyRingProtector)SecretKeyRingProtector.unprotectedKeys());
        PGPSignatureGenerator generator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), HashAlgorithm.SHA512.getAlgorithmId()));
        generator.init(SignatureType.CERTIFICATION_REVOCATION.getCode(), privateKey);
        PGPSignature signature = generator.generateCertification(attribute, publicKey);
        publicKey = PGPPublicKey.addCertification((PGPPublicKey)publicKey, (PGPUserAttributeSubpacketVector)attribute, (PGPSignature)signature);
        SignatureVerifier.verifyUserAttributesRevocation((PGPUserAttributeSubpacketVector)attribute, (PGPSignature)signature, (PGPPublicKey)publicKey, (Policy)PGPainless.getPolicy(), (Date)new Date());
        PGPPublicKey finalPublicKey = publicKey;
        Assertions.assertThrows(SignatureValidationException.class, () -> SignatureVerifier.verifyUserAttributesCertification((PGPUserAttributeSubpacketVector)invalidAttribute, (PGPSignature)signature, (PGPPublicKey)finalPublicKey, (Policy)PGPainless.getPolicy(), (Date)new Date()));
    }

    static {
        PGPUserAttributeSubpacketVectorGenerator attrGen = new PGPUserAttributeSubpacketVectorGenerator();
        attrGen.setImageAttribute(1, image);
        attribute = attrGen.generate();
        byte[] modifiedImage = new byte[image.length];
        System.arraycopy(image, 0, modifiedImage, 0, image.length);
        modifiedImage[0] = 25;
        attrGen = new PGPUserAttributeSubpacketVectorGenerator();
        attrGen.setImageAttribute(1, modifiedImage);
        invalidAttribute = attrGen.generate();
    }
}

