/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import java.util.List;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.key.util.KeyIdUtil;
import org.pgpainless.signature.SignatureUtils;

public class SignatureUtilsTest {
    @Test
    public void readSignaturesFromCompressedData() throws PGPException, IOException {
        String compressed = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nowHrKGVhEOZiYGNlSoxcsJtBkVMg3OzZZKnz5jxiiiz+aTG+h46kcR9zinOECZ/o\nYmTYsKve/opb3v/o8J0qq1/MFFBhP9jfEq+/avK6qPMrlh70Zfinu96c+cncX9GK\nB4ui3fUfbUo8tFrVTIRn7kROq69H77hd6cCw9susVdls1as1gNYunnp5V8Qp+wX3\n+jUnwoRB1p4SfPk412lb/cSmShb211fOX07h0JxVH1JXsc/vi2mi5ieG/2Xxb5tk\nLE+r7WwruxSaeXLuLsOmXTPZD0/VtvlqO89RYjsA\n=yZ18\n-----END PGP MESSAGE-----";
        List signatures = SignatureUtils.readSignatures((String)compressed);
        Assertions.assertEquals((int)2, (int)signatures.size());
        Assertions.assertEquals((long)KeyIdUtil.fromLongKeyId((String)"5736E6931ACF370C"), (long)((PGPSignature)signatures.get(0)).getKeyID());
        Assertions.assertEquals((long)KeyIdUtil.fromLongKeyId((String)"F49AAA6B067BAB28"), (long)((PGPSignature)signatures.get(1)).getKeyID());
    }

    @Test
    public void noIssuerResultsInKeyId0() throws PGPException, IOException {
        String sig = "-----BEGIN PGP SIGNATURE-----\n\nwsEaBAABCABOBYJhVBVcRxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ+goUZDURlALH597rQCp41yYHOF90OfPRrp6TSZAA/nQAAAeOQwAni7j\nR4YEXpcDfqwjOPIvq5i7VWBR5EdESvR1fJHD99y4TyllezSpQcmZSGrkIcFRgTxR\nCwJ6oOsY4QILFF5N330Bs7HQfTbdgpx29ELo+8PuizRvhRVlQack/GPoRON/QQDz\nEBjZwiiPHgyw3CeQahHqSPgUT5JvW5yOOs31AhDlgen0qRHKtRwaI+5M5Y9nHR6z\nH2o5xapE4Vz647sPkl269Sd4kl/qkInoyKf1x1U6bu6g9Onr1fafM1HLiGkJl0Sk\nYNHCHdnBbyZBJt3ijCokOAGe7DIHvz5rv9iO/WDdC5Tw9XJlrFTI4xAv0EXJCSZm\n9eVJbaOEmnjqwaZNf4tS+j6+Blp/1p0YMd/10Fh6cmLYyM2mDBB60pE/Y3ARS1lP\nfta43BXTAWu6h+ZT2gncbBv+yAxmMEMY2iBk11dCLrSFWGEcitrOigCLMrPdCKCl\n7zv9ar9WsNOibOEaso+MF7oAw+97o1nRXPHg/5FzcmosqKU3VJZU8QZfETO7\n=YWPw\n-----END PGP SIGNATURE-----";
        PGPSignature signature = (PGPSignature)SignatureUtils.readSignatures((String)sig).get(0);
        Assertions.assertEquals((long)0L, (long)SignatureUtils.determineIssuerKeyId((PGPSignature)signature));
    }

    @Test
    public void skipInvalidSignatures() throws PGPException, IOException {
        String sigs = "-----BEGIN PGP SIGNATURE-----\n\nwsE7FwABCgBvBYJhVBVECRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmfYpOWFSlKZpeZQTVMyX5UaWW+12r4Xb0EAFS4gOWJ/\nmhYhBNGmbhojsYLJmA94jPv8yCoBXnMwAABpyQwAorVkBMS2DTb5rYFPjWjoIo1A\n3SiYkgPzddqc8ZvTu3zlEXpoGzKQLrXW3AGCuXCeEst+kPV6j33zZiPFSdcn0Ddg\nQUWlxhmsVJ/ePujwfVyPLJISE/g1486qMERSnOKKyL7u62uwCggRzZMYKOC12PFO\n+9OsISkPs+BqsV7jd6L2NJCBZ0VFCP2kE4vMty0VltIa3nfr1PgWPH3ekBPt3a0p\nOF/aSckV0gy4t7JqT9nxU5oWwxef1TQuQ8yh96gBSFUcS58ov+tBuMIjphpKexxU\nHlOTDVRG8+qUiScGFrc1aavepd9x60aHLBSwyGt4/ZhPvRp3fljyGqSapSUmCeFJ\nFN+p7Ne35GO/lrr6Aao3HH1xVGF4+Jn7N8CgN/dsKWa+gSrnKZbYo0Sa7hx6yRtm\na45VSoRmjEjP+cL+lvDBTqvv3anufZ5OCIzt2sUFJfWF6bOPjc+1X294qYNpVX6j\nxFWiAQt5XvispaNnuHE5tnlI7pLJ66zCU/Kl4WgywsE7BAABCgBvBYJhVBVECRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmfY\npOWFSlKZpeZQTVMyX5UaWW+12r4Xb0EAFS4gOWJ/mhYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAABpyQwAorVkBMS2DTb5rYFPjWjoIo1A3SiYkgPzddqc8ZvTu3zlEXpo\nGzKQLrXW3AGCuXCeEst+kPV6j33zZiPFSdcn0DdgQUWlxhmsVJ/ePujwfVyPLJIS\nE/g1486qMERSnOKKyL7u62uwCggRzZMYKOC12PFO+9OsISkPs+BqsV7jd6L2NJCB\nZ0VFCP2kE4vMty0VltIa3nfr1PgWPH3ekBPt3a0pOF/aSckV0gy4t7JqT9nxU5oW\nwxef1TQuQ8yh96gBSFUcS58ov+tBuMIjphpKexxUHlOTDVRG8+qUiScGFrc1aave\npd9x60aHLBSwyGt4/ZhPvRp3fljyGqSapSUmCeFJFN+p7Ne35GO/lrr6Aao3HH1x\nVGF4+Jn7N8CgN/dsKWa+gSrnKZbYo0Sa7hx6yRtma45VSoRmjEjP+cL+lvDBTqvv\n3anufZ5OCIzt2sUFJfWF6bOPjc+1X294qYNpVX6jxFWiAQt5XvispaNnuHE5tnlI\n7pLJ66zCU/Kl4Wgy\n=fvS+\n-----END PGP SIGNATURE-----\n";
        List signatures = SignatureUtils.readSignatures((String)sigs);
        Assertions.assertEquals((int)1, (int)signatures.size());
    }
}

