/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.SignatureValidator;

public class SignatureWasPossiblyMadeByKeyTest {
    public static PGPPublicKeyRing CERT;
    public static PGPPublicKey SIGKEY;
    public static PGPPublicKey NOSIGKEY;

    @Test
    public void issuer() throws PGPException, IOException {
        String sigWithIssuer = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCABlBYJgyf21RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ41vMHyr0Q9WbEh89cDcZt1LU9wR1Li+3wXFW0I0Lv4qFiEE0aZuGiOx\ngsmYD3iM+/zIKgFeczAACgkQ+/zIKgFeczCN/Av+P/RqTj8hMDTsoQWggQS3EPmx\n5u43yp8JCNuIKiDwTy+civQpAsfWLKhwmHZqokPonMtVSvxH9RFry9x8MpaaQzag\ngNO2XwsFFpYa3ce/vjOHv+b9JGfPsSak6RvcPKV99AjqAnxDj93Q9od5DzmWo4jp\ni9zt1Kj1AGEgqg/tp9jmmIEJ6ZgjM1sAysyE2YFU0hc0xySKI8+pBk8YG3fj8Twq\nd6FDQ3CTvpApdrL5EKW3qW1K/vBvmck15GZOxAsiXaPoiIPDJPxBCy0koK7z/Z+0\nvCft+isreOB9B1b68iGdaET9W+bd0ODdZHTfi7KmtG1D8+Ep4oVL8IRuWmf2M1Z9\nqI93KxIYqanw0I5HDsfd/5IQ4X1ZD5hoMy+ICLKHQirQzyXL1tjYcw6NPJt0jAHR\nLNlerP+KD288SPzu7jymsRXfxp91F1n+UT8n7kG16YARBGhc7hen858EJXn9dtWi\ncqP71SMuOwD+JNuWQCd4e1WaTWNXrB1xerzmuWFc\n=4ZFC\n-----END PGP SIGNATURE-----";
        this.assertWasPossiblyMadeByKey(SIGKEY, this.get(sigWithIssuer));
    }

    @Test
    public void hashedIssuer() throws PGPException, IOException {
        String sigWithHashedIssuer = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCABvBYJgyf21CRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmcQXJVlUI2e8ug0H1ekty9QUCLzgzv/H/U243WfBpJP\nPBYhBNGmbhojsYLJmA94jPv8yCoBXnMwAADK5Av/XIuS13XrduVk3V7a28Uz9ARz\nl2eHgOuSyM8IovCaWvO+L8KaCsFXVYUB0cHEHzH0QfyMapkVymsjLmqT5ULdwdKf\nHsPluhZQlgEzeS043/uoikBgGOF+u0hdsibVpW0TVp0vZgBpuD7raLQQ9eWymRUE\ndZ1dwWPc5OD3OV6jVwjNPoLy8yQaYLhfRser/h+pIFTL8XSqjPMDklN+oLnzZkvo\nA0OCupqpiDtrREmeTVKDkL0DJ0DM7qMky7oI1qB4i3Ryt7gMUzpy7nK6APosi5Rg\nvPuofxHle32pzaMDbBFQFcFYsXFdzmQdCcIx1myo6yrdkq4RMYXR20+cE+4R0pcQ\nJZhDFyx3d/7vloWXeXM9HT+asPVfub+HXPFkqvsFulogpo/Pr66Og6+fRc2FPPSO\nHmamWg1mMpzca8F35zZie1ICT7Qdef+aBcUb/7gwlv0Fd4FYWaIcleve4YtEacE/\nQ0Quxar3DOTtNNQVrXeoeIlVGue0pNCwg6abDj5N\n=IcX1\n-----END PGP SIGNATURE-----\n";
        this.assertWasPossiblyMadeByKey(SIGKEY, this.get(sigWithHashedIssuer));
    }

    @Test
    public void noIssuerNoFingerprint() throws PGPException, IOException {
        String sigWithNoIssuerNoFingerprint = "-----BEGIN PGP SIGNATURE-----\n\nwsEaBAABCABOBYJgyf21RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ2T4siBf1CQ8wqT+oTCmxVm6OC+KC/kvqQdQ4AAGC68JAAC3Zwv/d70q\nhUeTJrMXGej1/FkNOSKyjVRnJusDEojc4eQ/+Ov8jdByj2Rcr44UH7ZICtWuR4gc\nZrG9+DBFKgeuY6TawyBbTj3NU4IEOqihtn8RDBEXKIc91cW9BuqLyxvoUr432g6y\n7l7nyXf17kPx8E62BjOhUz0NuwRQ5c2pnIRDe37xX0519DMf9PaywTAgs4eZaKXd\ne1JLYvkd7BuMaT17VEggdRLM3GJGAJfZQ4+eoOmAzGRs1xGZrvcs2AH+OOzslU5l\nt2nR9N7BCLX0NZVIP5KpRzw/puIFBiFj7zrPb7CJqKb0UEK8qngukASlvzYZTjHA\n03qAeYqUj6LXTPNYlobPsGB0Srt2j7ycpeOYh6c3l7pKkvyaQL4QVawECMxsymu0\niMrLtyuWclsBcRDezIHQqKHOhSeCLt67SJj2+fCa+7WgQdvBT//3McFVsWnLQJsq\nzVflI4b3E2kyhRgYK7f6jaa0OZ7BJRpQ3RRNk0Oq3rIYjysrwkbBG9N6tnCk\n=NdKQ\n-----END PGP SIGNATURE-----";
        this.assertWasPossiblyMadeByKey(SIGKEY, this.get(sigWithNoIssuerNoFingerprint));
    }

    @Test
    public void noIssuerUnhashedFingerprint() throws PGPException, IOException {
        String sigWithNoIssuerUnhashedFingerprint = "-----BEGIN PGP SIGNATURE-----\n\nwsExBAABCABOBYJgyf21RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ3rfvSuqnA0bf1EQnEstGhA5DCtJi6DDcXnosObaXtDLABcWIQTRpm4a\nI7GCyZgPeIz7/MgqAV5zMHc4C/0b582atQFBFrSn+YAtDMPChnu/p4DKDXu3Ytxf\nX04TYV2+31MtndB4OMs0IMijWBpLkBFp57ozwIlos+y2gWAiJJ/uyLOzJNYPsEzA\nWVbEOrTgmelkc0sYFZlL0JcNsaCmpWjXuhNNulTj2svmwyNrD/3sO2G2hZcGqDDd\nzREX0Z8rEAssk4UxJVwOqmvhspWRDT3/UYpAA7sMQa3NtoLB0BM/+/mPG78fmSsP\nCmquP71TF3VdbW3zDdeq71apJbGgLdbEKVbwqU7IHtMk3DA469rT0NHdNVbQu0Mv\nnbNA43fNfaBbT7ApFQgnzBMF+nBc+HLCJQxq4uRBRX0i2eh+hgFM8VxX8miV1iCT\no6NkMerueuXGFSGU37wGQQMdzOK13cW/Rp1DyFu3L0BSnFpykowdADmjAWhZYCMX\n6HAbz8mWRfNbNOahOtCVO3pojI8UiJ9ru7efTA/k3n06WYLndLcI3uW3Bn1F6/we\n7IQfGLcjtGngm993hPuCHrg/dnc=\n=LBou\n-----END PGP SIGNATURE-----\n";
        this.assertWasPossiblyMadeByKey(SIGKEY, this.get(sigWithNoIssuerUnhashedFingerprint));
    }

    @Test
    public void issuerMismatch() throws PGPException, IOException {
        String sig = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCABlBYJgyf21RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ41vMHyr0Q9WbEh89cDcZt1LU9wR1Li+3wXFW0I0Lv4qFiEE0aZuGiOx\ngsmYD3iM+/zIKgFeczAACgkQ+/zIKgFeczCN/Av+P/RqTj8hMDTsoQWggQS3EPmx\n5u43yp8JCNuIKiDwTy+civQpAsfWLKhwmHZqokPonMtVSvxH9RFry9x8MpaaQzag\ngNO2XwsFFpYa3ce/vjOHv+b9JGfPsSak6RvcPKV99AjqAnxDj93Q9od5DzmWo4jp\ni9zt1Kj1AGEgqg/tp9jmmIEJ6ZgjM1sAysyE2YFU0hc0xySKI8+pBk8YG3fj8Twq\nd6FDQ3CTvpApdrL5EKW3qW1K/vBvmck15GZOxAsiXaPoiIPDJPxBCy0koK7z/Z+0\nvCft+isreOB9B1b68iGdaET9W+bd0ODdZHTfi7KmtG1D8+Ep4oVL8IRuWmf2M1Z9\nqI93KxIYqanw0I5HDsfd/5IQ4X1ZD5hoMy+ICLKHQirQzyXL1tjYcw6NPJt0jAHR\nLNlerP+KD288SPzu7jymsRXfxp91F1n+UT8n7kG16YARBGhc7hen858EJXn9dtWi\ncqP71SMuOwD+JNuWQCd4e1WaTWNXrB1xerzmuWFc\n=4ZFC\n-----END PGP SIGNATURE-----";
        this.assertWasNotPossiblyMadeByKey(NOSIGKEY, this.get(sig));
    }

    @Test
    public void noIssuer_fingerprintMismatch() throws PGPException, IOException {
        String sigWithNoIssuerAndWrongFingerprint = "-----BEGIN PGP SIGNATURE-----\n\nwsExBAABCABlBYJgyf21RxQAAAAAAB4AIHNhbHRAbm90YXRpb25zLnNlcXVvaWEt\ncGdwLm9yZ4LlavMh1EAlex0cmzIH6jHzRv9iaqLPdHi1pM7J65EzFiEE0aZuGiOx\ngsmYD3iM+/zIKgFeczAAAIMIC/0QkkD7RcvKUogLhENpeGrQnkGmVEBupHz6V8LR\ni/DtlIBNjTRAEwDHcDDfn0JkY9Zp3E4IkNN6cJ9o8vsZvOMu0v9qQKVDwhy6N0SM\nBAOCJ+rNkZlXIWM8wyRzt52TWG6CStU2bbLJAq3EeEkZ2+WupCAdsVax0qrWJxQf\ntcm2lLQrtCa3gvRtaGCnmW1jrpvkkNZyC/bOBAazr4aD5lgeVtP8Oq3SI32xGV6f\nzCSfctIxGz9ZxQGe/VGHmgExkQ6SCaF3JhHHgZt/FCmquIK/IV5WIYAidWmFtQYI\n26jVUVUgNHU7Oxagx/55ZXUAMPIspO+J0HOLCpVQUTABBumhgwF6JkVnIn8ZO+vn\nGXIkZXQIK1Hx7M4xFYgJjva2ZwxCsENmtDp8FKyeTjq5QTU4Q1WSpJH6KVSpqCVM\nhyYvz7nf+kWf5Gm/Z0yGlkDhFnj3th4tUyytvypKgWeZu/1/0+Lfs293OrjjygCW\nlMirZ5N3oGYyNH4DQMJ1jeMwdbg=\n=A/zE\n-----END PGP SIGNATURE-----\n";
        this.assertWasNotPossiblyMadeByKey(NOSIGKEY, this.get(sigWithNoIssuerAndWrongFingerprint));
    }

    private PGPSignature get(String encoded) throws PGPException, IOException {
        return (PGPSignature)SignatureUtils.readSignatures((String)encoded).get(0);
    }

    private void assertWasPossiblyMadeByKey(PGPPublicKey signatureKey, PGPSignature signature) throws SignatureValidationException {
        SignatureValidator.wasPossiblyMadeByKey((PGPPublicKey)signatureKey).verify(signature);
    }

    private void assertWasNotPossiblyMadeByKey(PGPPublicKey signatureKey, PGPSignature signature) {
        Assertions.assertThrows(SignatureValidationException.class, () -> this.assertWasPossiblyMadeByKey(signatureKey, signature));
    }

    static {
        try {
            CERT = PGPainless.readKeyRing().publicKeyRing("-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: Bob's OpenPGP certificate\n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\nNEJd3XZRzaXZE2aAMQ==\n=NXei\n-----END PGP PUBLIC KEY BLOCK-----\n");
            SIGKEY = CERT.getPublicKey(new OpenPgpV4Fingerprint("D1A66E1A23B182C9980F788CFBFCC82A015E7330").getKeyId());
            NOSIGKEY = CERT.getPublicKey(new OpenPgpV4Fingerprint("1DDCE15F09217CEE2F3B37607C2FAA4DF93C37B2").getKeyId());
        }
        catch (IOException e) {
            Assertions.fail((String)"Cannot parse certificate");
        }
    }
}

