/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.key.TestKeys;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.ArmoredInputStreamFactory;
import org.pgpainless.util.ArmoredOutputStreamFactory;

public class ArmorUtilsTest {
    @Test
    public void testParseArmorHeader() throws IOException {
        String armoredKey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.68\nHash: SHA512\nComment: This is a comment\nComment: This is another comment\n\nmDMEYJ/OsRYJKwYBBAHaRw8BAQdAaOs6IF1fWhN/dqwfSrxD/MNnBXVEx8WlecCa\ncAiSCv60DnRlc3RAdGVzdC50ZXN0iHgEExYKACAFAmCfzrECGwMFFgIDAQAECwkI\nBwUVCgkICwIeAQIZAQAKCRD2lyhrcqSwzDWIAP9i6LfaUp3gEhGQR3FojyhfPVB1\nY3bBU7osj/XOpEN6RAD/YzL9VO45yYp1IUvU1NQWJy42ZHHZy4ZrjULLQ/HbpQW4\nOARgn86xEgorBgEEAZdVAQUBAQdASAPiuOakmDdL0HaSemeNB5Hl7lniD8vCeFgz\nOcgWjSYDAQgHiHUEGBYKAB0FAmCfzrECGwwFFgIDAQAECwkIBwUVCgkICwIeAQAK\nCRD2lyhrcqSwzJ4HAQD7uDYyEsqEGHI4LULfphxPSC5nG9pbBA3mL4ze46uDmAD/\naea172D0TfBwQXZxujLECTce5/1jyTaM+ee8gfw1BQ8=\n=RQHd\n-----END PGP PUBLIC KEY BLOCK-----";
        ByteArrayInputStream in = new ByteArrayInputStream(armoredKey.getBytes(StandardCharsets.UTF_8));
        ArmoredInputStream armorIn = ArmoredInputStreamFactory.get((InputStream)in);
        Assertions.assertEquals((int)0, (int)ArmorUtils.getCharsetHeaderValues((ArmoredInputStream)armorIn).size());
        List versionHeader = ArmorUtils.getVersionHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)1, (int)versionHeader.size());
        Assertions.assertEquals((Object)"BCPG v1.68", versionHeader.get(0));
        List hashHeader = ArmorUtils.getHashHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)1, (int)hashHeader.size());
        Assertions.assertEquals((Object)"SHA512", hashHeader.get(0));
        List hashes = ArmorUtils.getHashAlgorithms((ArmoredInputStream)armorIn);
        Assertions.assertEquals((Object)HashAlgorithm.SHA512, hashes.get(0));
        List commentHeader = ArmorUtils.getCommendHeaderValues((ArmoredInputStream)armorIn);
        Assertions.assertEquals((int)2, (int)commentHeader.size());
        Assertions.assertEquals((Object)"This is a comment", commentHeader.get(0));
        Assertions.assertEquals((Object)"This is another comment", commentHeader.get(1));
        Assertions.assertEquals((int)0, (int)ArmorUtils.getMessageIdHeaderValues((ArmoredInputStream)armorIn).size());
    }

    @Test
    public void testSetMessageId() {
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)new ByteArrayOutputStream());
        ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"abcdefghi01234567890123456789012");
        Assertions.assertThrows(NullPointerException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"tooShort"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"toLooooooooooooooooooooooooooooooooooong"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"contains spaces 7890123456789012"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ArmorUtils.addMessageIdHeader((ArmoredOutputStream)armor, (String)"contains\nnewlines\n12345678901234"));
    }

    @Test
    public void testAddCommentAndHashHeaders() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armor = new ArmoredOutputStream((OutputStream)out);
        ArmorUtils.addCommentHeader((ArmoredOutputStream)armor, (String)"This is a comment.");
        ArmorUtils.addHashAlgorithmHeader((ArmoredOutputStream)armor, (HashAlgorithm)HashAlgorithm.SHA224);
        secretKeys.encode((OutputStream)armor);
        armor.close();
        String armored = out.toString();
        Assertions.assertTrue((boolean)armored.contains("Hash: SHA224"));
        Assertions.assertTrue((boolean)armored.contains("Comment: This is a comment."));
    }

    @Test
    public void toAsciiArmoredString() throws PGPException, IOException {
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        secretKeys.encode((OutputStream)bytes);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes.toByteArray());
        String ascii = ArmorUtils.toAsciiArmoredString((InputStream)in);
        Assertions.assertTrue((boolean)ascii.startsWith("-----BEGIN PGP PRIVATE KEY BLOCK-----\n"));
    }

    @Test
    public void testSetCustomVersionHeader() throws IOException {
        ArmoredOutputStreamFactory.setVersionInfo((String)"MyVeryFirstOpenPGPProgram 1.0");
        ArmoredOutputStreamFactory.setComment((String)"This is a comment\nThat spans multiple\nLines!");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.get((OutputStream)out);
        byte[] data = "This is a very secret message that nobody is allowed to read.".getBytes(StandardCharsets.UTF_8);
        armorOut.write(data);
        armorOut.close();
        Assertions.assertEquals((Object)"-----BEGIN PGP MESSAGE-----\nVersion: MyVeryFirstOpenPGPProgram 1.0\nComment: This is a comment\nComment: That spans multiple\nComment: Lines!\n\nVGhpcyBpcyBhIHZlcnkgc2VjcmV0IG1lc3NhZ2UgdGhhdCBub2JvZHkgaXMgYWxs\nb3dlZCB0byByZWFkLg==\n=XMZb\n-----END PGP MESSAGE-----\n", (Object)out.toString());
    }

    @Test
    public void decodeExampleTest() throws IOException, PGPException {
        String armored = "-----BEGIN PGP MESSAGE-----\nVersion: OpenPrivacy 0.99\n\nyDgBO22WxBHv7O8X7O/jygAEzol56iUKiXmV+XmpCtmpqQUKiQrFqclFqUDBovzS\nvBSFjNSiVHsuAA==\n=njUN\n-----END PGP MESSAGE-----";
        InputStream inputStream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(armored.getBytes(StandardCharsets.UTF_8)));
        BcPGPObjectFactory factory = new BcPGPObjectFactory(inputStream);
        PGPCompressedData compressed = (PGPCompressedData)factory.nextObject();
        factory = new BcPGPObjectFactory(compressed.getDataStream());
        PGPLiteralData literal = (PGPLiteralData)factory.nextObject();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"_CONSOLE", (Object)literal.getFileName());
        Streams.pipeAll((InputStream)literal.getInputStream(), (OutputStream)out);
        Assertions.assertEquals((Object)"Can't anyone keep a secret around here?\n", (Object)out.toString());
    }

    @AfterAll
    public static void resetHeaders() {
        ArmoredOutputStreamFactory.resetComment();
        ArmoredOutputStreamFactory.resetVersionInfo();
    }
}

