/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;

public class GuessPreferredHashAlgorithmTest {
    @Test
    public void guessPreferredHashAlgorithmsAssumesHashAlgoUsedBySelfSig() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException, IOException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.generateKeyRing().setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}).overridePreferredHashAlgorithms(new HashAlgorithm[0]).overridePreferredSymmetricKeyAlgorithms(new SymmetricKeyAlgorithm[0]).overridePreferredCompressionAlgorithms(new CompressionAlgorithm[0]))).addUserId("test@test.test").build();
        PGPPublicKey publicKey = secretKeys.getPublicKey();
        Assertions.assertEquals(Collections.emptyList(), (Object)OpenPgpKeyAttributeUtil.getPreferredHashAlgorithms((PGPPublicKey)publicKey));
        Assertions.assertEquals(Collections.singletonList(HashAlgorithm.SHA512), (Object)OpenPgpKeyAttributeUtil.guessPreferredHashAlgorithms((PGPPublicKey)publicKey));
    }
}

