/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.weird_keys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.WeirdKeys;
import org.pgpainless.key.util.KeyRingUtils;

public class TestTwoSubkeysEncryption {
    private static final String PLAINTEXT = "Hello World!";

    private ByteArrayInputStream getPlainIn() {
        return new ByteArrayInputStream(PLAINTEXT.getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testEncryptsToBothSubkeys() throws IOException, PGPException {
        PGPSecretKeyRing twoSuitableSubkeysKeyRing = WeirdKeys.getTwoCryptSubkeysKey();
        PGPPublicKeyRing publicKeys = KeyRingUtils.publicKeyRingFrom((PGPSecretKeyRing)twoSuitableSubkeysKeyRing);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncryptionStream encryptionStream = PGPainless.encryptAndOrSign().onOutputStream((OutputStream)out).withOptions(ProducerOptions.encrypt((EncryptionOptions)new EncryptionOptions(EncryptionPurpose.STORAGE_AND_COMMUNICATIONS).addRecipient(publicKeys, EncryptionOptions.encryptToAllCapableSubkeys())).setAsciiArmor(false));
        Streams.pipeAll((InputStream)this.getPlainIn(), (OutputStream)encryptionStream);
        encryptionStream.close();
        EncryptionResult metadata = encryptionStream.getResult();
        Assertions.assertEquals((int)2, (int)metadata.getRecipients().size());
    }
}

