/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.SignatureVerification;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.CertificateValidator;
import org.pgpainless.signature.DetachedSignatureCheck;
import org.pgpainless.signature.OnePassSignatureCheck;
import org.pgpainless.signature.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignatureInputStream
extends FilterInputStream {
    protected SignatureInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public static class VerifySignatures
    extends SignatureInputStream {
        private static final Logger LOGGER = LoggerFactory.getLogger(VerifySignatures.class);
        private final List<OnePassSignatureCheck> opSignatures;
        private final List<DetachedSignatureCheck> detachedSignatures;
        private final ConsumerOptions options;
        private final OpenPgpMetadata.Builder resultBuilder;

        public VerifySignatures(InputStream literalDataStream, List<OnePassSignatureCheck> opSignatures, List<DetachedSignatureCheck> detachedSignatures, ConsumerOptions options, OpenPgpMetadata.Builder resultBuilder) {
            super(literalDataStream);
            this.opSignatures = opSignatures;
            this.detachedSignatures = detachedSignatures;
            this.options = options;
            this.resultBuilder = resultBuilder;
        }

        @Override
        public int read() throws IOException {
            boolean endOfStream;
            int data = super.read();
            boolean bl = endOfStream = data == -1;
            if (endOfStream) {
                this.verifyOnePassSignatures();
                this.verifyDetachedSignatures();
            } else {
                byte b = (byte)data;
                this.updateOnePassSignatures(b);
                this.updateDetachedSignatures(b);
            }
            return data;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            boolean endOfStream;
            int read = super.read(b, off, len);
            boolean bl = endOfStream = read == -1;
            if (endOfStream) {
                this.verifyOnePassSignatures();
                this.verifyDetachedSignatures();
            } else {
                this.updateOnePassSignatures(b, off, read);
                this.updateDetachedSignatures(b, off, read);
            }
            return read;
        }

        private synchronized void verifyOnePassSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                if (opSignature.getSignature() == null) {
                    LOGGER.warn("Found OnePassSignature without respective signature packet -> skip");
                    continue;
                }
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(opSignature.getSignature());
                    CertificateValidator.validateCertificateAndVerifyOnePassSignature(opSignature, policy);
                    this.resultBuilder.addVerifiedInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", new Object[]{opSignature.getSigningKey(), e.getMessage(), e});
                    this.resultBuilder.addInvalidInbandSignature(new SignatureVerification(opSignature.getSignature(), opSignature.getSigningKey()), e);
                }
            }
        }

        private void verifyDetachedSignatures() {
            Policy policy = PGPainless.getPolicy();
            for (DetachedSignatureCheck s : this.detachedSignatures) {
                try {
                    SignatureValidator.signatureWasCreatedInBounds(this.options.getVerifyNotBefore(), this.options.getVerifyNotAfter()).verify(s.getSignature());
                    CertificateValidator.validateCertificateAndVerifyInitializedSignature(s.getSignature(), (PGPPublicKeyRing)s.getSigningKeyRing(), policy);
                    this.resultBuilder.addVerifiedDetachedSignature(new SignatureVerification(s.getSignature(), s.getSigningKeyIdentifier()));
                }
                catch (SignatureValidationException e) {
                    LOGGER.warn("One-pass-signature verification failed for signature made by key {}: {}", new Object[]{s.getSigningKeyIdentifier(), e.getMessage(), e});
                    this.resultBuilder.addInvalidDetachedSignature(new SignatureVerification(s.getSignature(), s.getSigningKeyIdentifier()), e);
                }
            }
        }

        private void updateOnePassSignatures(byte data) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(data);
            }
        }

        private void updateOnePassSignatures(byte[] bytes, int offset, int length) {
            for (OnePassSignatureCheck opSignature : this.opSignatures) {
                opSignature.getOnePassSignature().update(bytes, offset, length);
            }
        }

        private void updateDetachedSignatures(byte b) {
            for (DetachedSignatureCheck detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b);
            }
        }

        private void updateDetachedSignatures(byte[] b, int off, int read) {
            for (DetachedSignatureCheck detachedSignature : this.detachedSignatures) {
                detachedSignature.getSignature().update(b, off, read);
            }
        }
    }
}

