/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.ecc.ecdh;

import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.Nonnull;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;

public final class ECDH
implements KeyType {
    private final EllipticCurve curve;

    private ECDH(EllipticCurve curve) {
        this.curve = curve;
    }

    public static ECDH fromCurve(@Nonnull EllipticCurve curve) {
        return new ECDH(curve);
    }

    @Override
    public String getName() {
        return "ECDH";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.ECDH;
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new ECNamedCurveGenParameterSpec(this.curve.getName());
    }
}

