/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    private DateUtil() {
    }

    public static SimpleDateFormat getParser() {
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        return parser;
    }

    public static Date parseUTCDate(String dateString) {
        try {
            return DateUtil.getParser().parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatUTCDate(Date date) {
        return DateUtil.getParser().format(date);
    }

    public static Date now() {
        return DateUtil.parseUTCDate(DateUtil.formatUTCDate(new Date()));
    }
}

