/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.util.PGPUtilWrapper;

public class PGPUtilWrapperTest {
    @Test
    public void testGetDecoderStream() throws IOException {
        ByteArrayInputStream msg = new ByteArrayInputStream("Foo\nBar".getBytes(StandardCharsets.UTF_8));
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStream litOut = literalDataGenerator.open((OutputStream)out, 't', "", new Date(), new byte[512]);
        Streams.pipeAll((InputStream)msg, (OutputStream)litOut);
        literalDataGenerator.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BcPGPObjectFactory objectFactory = new BcPGPObjectFactory((InputStream)in);
        PGPLiteralData literalData = (PGPLiteralData)objectFactory.nextObject();
        InputStream litIn = literalData.getDataStream();
        BufferedInputStream bufIn = new BufferedInputStream(litIn);
        InputStream decoderStream = PGPUtilWrapper.getDecoderStream((BufferedInputStream)bufIn);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)decoderStream, (OutputStream)result);
        Assertions.assertEquals((Object)"Foo\nBar", (Object)result.toString());
    }
}

