/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.io.IOException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.TestKeys;

public class ImportExportKeyTest {
    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void testExportImportPublicKeyRing(ImplementationFactory implementationFactory) throws IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPPublicKeyRing publicKeys = TestKeys.getJulietPublicKeyRing();
        BcKeyFingerprintCalculator calc = new BcKeyFingerprintCalculator();
        byte[] bytes = publicKeys.getEncoded();
        PGPPublicKeyRing parsed = new PGPPublicKeyRing(bytes, (KeyFingerPrintCalculator)calc);
        Assertions.assertArrayEquals((byte[])publicKeys.getEncoded(), (byte[])parsed.getEncoded());
    }

    @Test
    public void testExportImportSecretKeyRing() throws IOException, PGPException {
        PGPSecretKeyRing secretKeys = TestKeys.getRomeoSecretKeyRing();
        byte[] bytes = secretKeys.getEncoded();
        PGPSecretKeyRing parsed = new PGPSecretKeyRing(bytes, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Assertions.assertArrayEquals((byte[])secretKeys.getEncoded(), (byte[])parsed.getEncoded());
        Assertions.assertEquals((long)secretKeys.getPublicKey().getKeyID(), (long)parsed.getPublicKey().getKeyID());
    }
}

