/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.JUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.DateUtil;

public class ChangeExpirationOnKeyWithDifferentSignatureTypesTest {
    private static final String keyWithGenericCertification = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 8204 4993 BF17 BC95 F1BF  4E80 9E47 B575 6733 80C1\nComment: Test Key\n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\n=gbUk\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String keyWithCasualCertification = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 2077 4DD5 1456 73A1 ACB8  416E 4999 42A2 27CD 977C\nComment: Test Key\n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\n=GIQn\n-----END PGP PRIVATE KEY BLOCK-----";

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void setExpirationDate_keyHasSigClass10(ImplementationFactory implementationFactory) throws PGPException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing keys = PGPainless.readKeyRing().secretKeyRing(keyWithGenericCertification);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        this.executeTestForKeys(keys, protector);
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void setExpirationDate_keyHasSigClass12(ImplementationFactory implementationFactory) throws PGPException, IOException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing keys = PGPainless.readKeyRing().secretKeyRing(keyWithCasualCertification);
        SecretKeyRingProtector protector = SecretKeyRingProtector.unprotectedKeys();
        this.executeTestForKeys(keys, protector);
    }

    private void executeTestForKeys(PGPSecretKeyRing keys, SecretKeyRingProtector protector) throws PGPException {
        Date expirationDate = new Date(new Date().getTime() + 1209600000L);
        expirationDate = DateUtil.parseUTCDate((String)DateUtil.formatUTCDate((Date)expirationDate));
        PGPSecretKeyRing modded = PGPainless.modifyKeyRing((PGPSecretKeyRing)keys).setExpirationDate(expirationDate, protector).done();
        JUtils.assertDateEquals(expirationDate, PGPainless.inspectKeyRing((PGPKeyRing)modded).getPrimaryKeyExpirationDate());
    }
}

