/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.modification;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.TestKeys;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.util.DateUtil;

public class ChangeExpirationTest {
    private final OpenPgpV4Fingerprint subKeyFingerprint = new OpenPgpV4Fingerprint("F73FDE6439ABE210B1AF4EDD273EF7A0C749807B");

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void setExpirationDateAndThenUnsetIt_OnPrimaryKey(ImplementationFactory implementationFactory) throws PGPException, IOException, InterruptedException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
        Date date = DateUtil.parseUTCDate((String)"2020-11-27 16:10:32 UTC");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getPrimaryKeyExpirationDate().getTime());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
    }

    @ParameterizedTest
    @MethodSource(value={"org.pgpainless.util.TestImplementationFactoryProvider#provideImplementationFactories"})
    public void setExpirationDateAndThenUnsetIt_OnSubkey(ImplementationFactory implementationFactory) throws PGPException, IOException, InterruptedException {
        ImplementationFactory.setFactoryImplementation((ImplementationFactory)implementationFactory);
        PGPSecretKeyRing secretKeys = TestKeys.getEmilSecretKeyRing();
        KeyRingInfo sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Date date = DateUtil.parseUTCDate((String)"2020-11-27 16:10:32 UTC");
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(this.subKeyFingerprint, date, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNotNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
        Assertions.assertEquals((long)date.getTime(), (long)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint).getTime());
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
        Thread.sleep(1100L);
        secretKeys = PGPainless.modifyKeyRing((PGPSecretKeyRing)secretKeys).setExpirationDate(this.subKeyFingerprint, null, (SecretKeyRingProtector)new UnprotectedKeysProtector()).done();
        sInfo = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertNull((Object)sInfo.getSubkeyExpirationDate(this.subKeyFingerprint));
        Assertions.assertNull((Object)sInfo.getPrimaryKeyExpirationDate());
    }
}

