/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class SubkeyIdentifier {
    private final OpenPgpV4Fingerprint primaryKeyFingerprint;
    private final OpenPgpV4Fingerprint subkeyFingerprint;

    public SubkeyIdentifier(PGPKeyRing keyRing) {
        this(keyRing, keyRing.getPublicKey().getKeyID());
    }

    public SubkeyIdentifier(@Nonnull PGPKeyRing keyRing, long keyId) {
        PGPPublicKey subkey = keyRing.getPublicKey(keyId);
        if (subkey == null) {
            throw new NoSuchElementException("Key ring does not contain subkey with id " + Long.toHexString(keyId));
        }
        this.primaryKeyFingerprint = new OpenPgpV4Fingerprint(keyRing);
        this.subkeyFingerprint = new OpenPgpV4Fingerprint(subkey);
    }

    public SubkeyIdentifier(@Nonnull PGPKeyRing keyRing, @Nonnull OpenPgpV4Fingerprint subkeyFingerprint) {
        this(new OpenPgpV4Fingerprint(keyRing), subkeyFingerprint);
    }

    public SubkeyIdentifier(@Nonnull OpenPgpV4Fingerprint primaryKeyFingerprint) {
        this(primaryKeyFingerprint, primaryKeyFingerprint);
    }

    public SubkeyIdentifier(@Nonnull OpenPgpV4Fingerprint primaryKeyFingerprint, @Nonnull OpenPgpV4Fingerprint subkeyFingerprint) {
        this.primaryKeyFingerprint = primaryKeyFingerprint;
        this.subkeyFingerprint = subkeyFingerprint;
    }

    @Nonnull
    public OpenPgpV4Fingerprint getFingerprint() {
        return this.getSubkeyFingerprint();
    }

    public long getKeyId() {
        return this.getSubkeyId();
    }

    @Nonnull
    public OpenPgpV4Fingerprint getPrimaryKeyFingerprint() {
        return this.primaryKeyFingerprint;
    }

    public long getPrimaryKeyId() {
        return this.getPrimaryKeyFingerprint().getKeyId();
    }

    @Nonnull
    public OpenPgpV4Fingerprint getSubkeyFingerprint() {
        return this.subkeyFingerprint;
    }

    public long getSubkeyId() {
        return this.getSubkeyFingerprint().getKeyId();
    }

    public int hashCode() {
        return this.primaryKeyFingerprint.hashCode() * 31 + this.subkeyFingerprint.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubkeyIdentifier)) {
            return false;
        }
        SubkeyIdentifier other = (SubkeyIdentifier)obj;
        return this.getPrimaryKeyFingerprint().equals(other.getPrimaryKeyFingerprint()) && this.getSubkeyFingerprint().equals(other.getSubkeyFingerprint());
    }

    public String toString() {
        return this.getSubkeyFingerprint() + " " + this.getPrimaryKeyFingerprint();
    }
}

