/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum SignatureSubpacket {
    signatureCreationTime(2),
    signatureExpirationTime(3),
    exportableCertification(4),
    trustSignature(5),
    regularExpression(6),
    revocable(7),
    keyExpirationTime(9),
    placeholder(10),
    preferredSymmetricAlgorithms(11),
    revocationKey(12),
    issuerKeyId(16),
    notationData(20),
    preferredHashAlgorithms(21),
    preferredCompressionAlgorithms(22),
    keyServerPreferences(23),
    preferredKeyServers(24),
    primaryUserId(25),
    policyUrl(26),
    keyFlags(27),
    signerUserId(28),
    revocationReason(29),
    features(30),
    signatureTarget(31),
    embeddedSignature(32),
    issuerFingerprint(33),
    preferredAEADAlgorithms(34),
    intendedRecipientFingerprint(35),
    attestedCertification(37);

    private static final Map<Integer, SignatureSubpacket> MAP;
    private final int code;

    private SignatureSubpacket(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static SignatureSubpacket fromCode(int code) {
        SignatureSubpacket tag = MAP.get(code);
        if (tag == null) {
            throw new IllegalArgumentException("No SignatureSubpacket tag found with code " + code);
        }
        return tag;
    }

    public static List<SignatureSubpacket> fromCodes(int[] codes) {
        ArrayList<SignatureSubpacket> tags = new ArrayList<SignatureSubpacket>();
        for (int code : codes) {
            tags.add(SignatureSubpacket.fromCode(code));
        }
        return tags;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, SignatureSubpacket>();
        for (SignatureSubpacket p : SignatureSubpacket.values()) {
            MAP.put(p.code, p);
        }
    }
}

