/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.cleartext_signatures;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.util.ArmoredInputStreamFactory;

public class CleartextSignatureProcessor {
    private static final Logger LOGGER = Logger.getLogger(CleartextSignatureProcessor.class.getName());
    private final ArmoredInputStream in;
    private final ConsumerOptions options;
    private final MultiPassStrategy multiPassStrategy;

    public CleartextSignatureProcessor(InputStream inputStream, ConsumerOptions options, MultiPassStrategy multiPassStrategy) throws IOException {
        this.in = inputStream instanceof ArmoredInputStream ? (ArmoredInputStream)inputStream : ArmoredInputStreamFactory.get(inputStream);
        this.options = options;
        this.multiPassStrategy = multiPassStrategy;
    }

    public DecryptionStream getVerificationStream() throws IOException, PGPException {
        OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
        resultBuilder.setCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED).setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm.NULL).setFileEncoding(StreamEncoding.TEXT);
        PGPSignatureList signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage((InputStream)this.in, this.multiPassStrategy.getMessageOutputStream());
        for (PGPSignature signature : signatures) {
            this.options.addVerificationOfDetachedSignature(signature);
        }
        return PGPainless.decryptAndOrVerify().onInputStream(this.multiPassStrategy.getMessageInputStream()).withOptions(this.options);
    }
}

