/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.cleartext_signatures;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;

public class WriteToFileMultiPassStrategy
implements MultiPassStrategy {
    private final File file;

    public WriteToFileMultiPassStrategy(File file) {
        this.file = file;
    }

    @Override
    public OutputStream getMessageOutputStream() throws IOException {
        boolean created;
        if (!this.file.exists() && !(created = this.file.createNewFile())) {
            throw new IOException("New file '" + this.file.getAbsolutePath() + "' was not created.");
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public InputStream getMessageInputStream() throws IOException {
        if (!this.file.exists()) {
            throw new IOException("File '" + this.file.getAbsolutePath() + "' does no longer exist.");
        }
        return new FileInputStream(this.file);
    }
}

