/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.subpackets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureSubpacket;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.signature.SignatureUtils;

public final class SignatureSubpacketsUtil {
    private SignatureSubpacketsUtil() {
    }

    public static IssuerFingerprint getIssuerFingerprint(PGPSignature signature) {
        return (IssuerFingerprint)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.issuerFingerprint);
    }

    public static OpenPgpFingerprint getIssuerFingerprintAsOpenPgpFingerprint(PGPSignature signature) {
        IssuerFingerprint subpacket = SignatureSubpacketsUtil.getIssuerFingerprint(signature);
        if (subpacket == null) {
            return null;
        }
        OpenPgpV4Fingerprint fingerprint = null;
        if (subpacket.getKeyVersion() == 4) {
            fingerprint = new OpenPgpV4Fingerprint(Hex.encode((byte[])subpacket.getFingerprint()));
        }
        return fingerprint;
    }

    public static IssuerKeyID getIssuerKeyId(PGPSignature signature) {
        return (IssuerKeyID)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.issuerKeyId);
    }

    public static Long getIssuerKeyIdAsLong(PGPSignature signature) {
        IssuerKeyID keyID = SignatureSubpacketsUtil.getIssuerKeyId(signature);
        if (keyID == null) {
            return null;
        }
        return keyID.getKeyID();
    }

    public static RevocationReason getRevocationReason(PGPSignature signature) {
        return (RevocationReason)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocationReason);
    }

    public static SignatureCreationTime getSignatureCreationTime(PGPSignature signature) {
        return (SignatureCreationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signatureCreationTime);
    }

    public static SignatureExpirationTime getSignatureExpirationTime(PGPSignature signature) {
        return (SignatureExpirationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signatureExpirationTime);
    }

    public static Date getSignatureExpirationTimeAsDate(PGPSignature signature) {
        SignatureExpirationTime subpacket = SignatureSubpacketsUtil.getSignatureExpirationTime(signature);
        if (subpacket == null) {
            return null;
        }
        return SignatureUtils.datePlusSeconds(signature.getCreationTime(), subpacket.getTime());
    }

    public static KeyExpirationTime getKeyExpirationTime(PGPSignature signature) {
        return (KeyExpirationTime)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.keyExpirationTime);
    }

    public static Date getKeyExpirationTimeAsDate(PGPSignature signature, PGPPublicKey signingKey) {
        KeyExpirationTime subpacket = SignatureSubpacketsUtil.getKeyExpirationTime(signature);
        if (subpacket == null) {
            return null;
        }
        if (signature.getKeyID() != signingKey.getKeyID()) {
            throw new IllegalArgumentException("Provided key (" + Long.toHexString(signingKey.getKeyID()) + ") did not create the signature (" + Long.toHexString(signature.getKeyID()) + ")");
        }
        return SignatureUtils.datePlusSeconds(signingKey.getCreationTime(), subpacket.getTime());
    }

    public static Revocable getRevocable(PGPSignature signature) {
        return (Revocable)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocable);
    }

    public static PreferredAlgorithms getPreferredSymmetricAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredSymmetricAlgorithms);
    }

    public static Set<SymmetricKeyAlgorithm> parsePreferredSymmetricKeyAlgorithms(PGPSignature signature) {
        LinkedHashSet<SymmetricKeyAlgorithm> algorithms = new LinkedHashSet<SymmetricKeyAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredSymmetricAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                algorithms.add(SymmetricKeyAlgorithm.fromId(code));
            }
        }
        return algorithms;
    }

    public static PreferredAlgorithms getPreferredHashAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredHashAlgorithms);
    }

    public static Set<HashAlgorithm> parsePreferredHashAlgorithms(PGPSignature signature) {
        LinkedHashSet<HashAlgorithm> algorithms = new LinkedHashSet<HashAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredHashAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                algorithms.add(HashAlgorithm.fromId(code));
            }
        }
        return algorithms;
    }

    public static PreferredAlgorithms getPreferredCompressionAlgorithms(PGPSignature signature) {
        return (PreferredAlgorithms)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.preferredCompressionAlgorithms);
    }

    public static Set<CompressionAlgorithm> parsePreferredCompressionAlgorithms(PGPSignature signature) {
        LinkedHashSet<CompressionAlgorithm> algorithms = new LinkedHashSet<CompressionAlgorithm>();
        PreferredAlgorithms preferences = SignatureSubpacketsUtil.getPreferredCompressionAlgorithms(signature);
        if (preferences != null) {
            for (int code : preferences.getPreferences()) {
                algorithms.add(CompressionAlgorithm.fromId(code));
            }
        }
        return algorithms;
    }

    public static PrimaryUserID getPrimaryUserId(PGPSignature signature) {
        return (PrimaryUserID)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.primaryUserId);
    }

    public static KeyFlags getKeyFlags(PGPSignature signature) {
        return (KeyFlags)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.keyFlags);
    }

    public static List<KeyFlag> parseKeyFlags(@Nullable PGPSignature signature) {
        if (signature == null) {
            return null;
        }
        KeyFlags keyFlags = SignatureSubpacketsUtil.getKeyFlags(signature);
        if (keyFlags == null) {
            return null;
        }
        return KeyFlag.fromBitmask(keyFlags.getFlags());
    }

    public static Features getFeatures(PGPSignature signature) {
        return (Features)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.features);
    }

    @Nullable
    public static Set<Feature> parseFeatures(PGPSignature signature) {
        Features features = SignatureSubpacketsUtil.getFeatures(signature);
        if (features == null) {
            return null;
        }
        return new LinkedHashSet<Feature>(Feature.fromBitmask(features.getData()[0]));
    }

    public static SignatureTarget getSignatureTarget(PGPSignature signature) {
        return (SignatureTarget)SignatureSubpacketsUtil.hashedOrUnhashed(signature, SignatureSubpacket.signatureTarget);
    }

    public static List<NotationData> getHashedNotationData(PGPSignature signature) {
        NotationData[] notations = signature.getHashedSubPackets().getNotationDataOccurrences();
        return Arrays.asList(notations);
    }

    public static List<NotationData> getHashedNotationData(PGPSignature signature, String notationName) {
        List<NotationData> allNotations = SignatureSubpacketsUtil.getHashedNotationData(signature);
        ArrayList<NotationData> withName = new ArrayList<NotationData>();
        for (NotationData data : allNotations) {
            if (!data.getNotationName().equals(notationName)) continue;
            withName.add(data);
        }
        return withName;
    }

    public static List<NotationData> getUnhashedNotationData(PGPSignature signature) {
        NotationData[] notations = signature.getUnhashedSubPackets().getNotationDataOccurrences();
        return Arrays.asList(notations);
    }

    public static List<NotationData> getUnhashedNotationData(PGPSignature signature, String notationName) {
        List<NotationData> allNotations = SignatureSubpacketsUtil.getUnhashedNotationData(signature);
        ArrayList<NotationData> withName = new ArrayList<NotationData>();
        for (NotationData data : allNotations) {
            if (!data.getNotationName().equals(notationName)) continue;
            withName.add(data);
        }
        return withName;
    }

    public static RevocationKey getRevocationKey(PGPSignature signature) {
        return (RevocationKey)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.revocationKey);
    }

    public static SignerUserID getSignerUserID(PGPSignature signature) {
        return (SignerUserID)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.signerUserId);
    }

    public static List<IntendedRecipientFingerprint> getIntendedRecipientFingerprints(PGPSignature signature) {
        org.bouncycastle.bcpg.SignatureSubpacket[] subpackets = signature.getHashedSubPackets().getSubpackets(SignatureSubpacket.intendedRecipientFingerprint.getCode());
        ArrayList<IntendedRecipientFingerprint> intendedRecipients = new ArrayList<IntendedRecipientFingerprint>(subpackets.length);
        for (org.bouncycastle.bcpg.SignatureSubpacket subpacket : subpackets) {
            intendedRecipients.add((IntendedRecipientFingerprint)subpacket);
        }
        return intendedRecipients;
    }

    public static PGPSignatureList getEmbeddedSignature(PGPSignature signature) throws PGPException {
        PGPSignatureList hashed = signature.getHashedSubPackets().getEmbeddedSignatures();
        if (!hashed.isEmpty()) {
            return hashed;
        }
        return signature.getUnhashedSubPackets().getEmbeddedSignatures();
    }

    public static Exportable getExportableCertification(PGPSignature signature) {
        return (Exportable)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.exportableCertification);
    }

    public static TrustSignature getTrustSignature(PGPSignature signature) {
        return (TrustSignature)SignatureSubpacketsUtil.hashed(signature, SignatureSubpacket.trustSignature);
    }

    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashed(PGPSignature signature, SignatureSubpacket type) {
        return SignatureSubpacketsUtil.getSignatureSubpacket(signature.getHashedSubPackets(), type);
    }

    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P unhashed(PGPSignature signature, SignatureSubpacket type) {
        return SignatureSubpacketsUtil.getSignatureSubpacket(signature.getUnhashedSubPackets(), type);
    }

    private static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P hashedOrUnhashed(PGPSignature signature, SignatureSubpacket type) {
        P hashedSubpacket = SignatureSubpacketsUtil.hashed(signature, type);
        return hashedSubpacket != null ? hashedSubpacket : SignatureSubpacketsUtil.unhashed(signature, type);
    }

    public static <P extends org.bouncycastle.bcpg.SignatureSubpacket> P getSignatureSubpacket(PGPSignatureSubpacketVector vector, SignatureSubpacket type) {
        org.bouncycastle.bcpg.SignatureSubpacket[] allPackets = vector.getSubpackets(type.getCode());
        if (allPackets.length == 0) {
            return null;
        }
        return (P)allPackets[allPackets.length - 1];
    }
}

